/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class ByteBufferUtils {
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0).asReadOnlyBuffer();

    private ByteBufferUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void put(ByteBuffer src, ByteBuffer dst) {
        if (src.remaining() > dst.remaining()) {
            int limit = src.limit();
            try {
                ((Buffer)src).limit(src.position() + dst.remaining());
                dst.put(src);
            }
            finally {
                ((Buffer)src).limit(limit);
            }
        } else {
            dst.put(src);
        }
    }

    public static void putUTF8(String src, ByteBuffer dst) {
        byte[] bytes = src.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 65535) {
            throw new IllegalArgumentException("UTF-8 encoded string must be less than 65536 bytes");
        }
        if (dst.remaining() < 2 + bytes.length) {
            throw new BufferOverflowException();
        }
        dst.asShortBuffer().put((short)bytes.length);
        ((Buffer)dst).position(dst.position() + 2);
        dst.put(bytes);
    }

    public static String getUTF8(ByteBuffer src) {
        if (src.remaining() < 2) {
            throw new BufferUnderflowException();
        }
        int length = src.asShortBuffer().get() & 0xFFFF;
        if (src.remaining() < length + 2) {
            throw new BufferUnderflowException();
        }
        ((Buffer)src).position(src.position() + 2);
        byte[] bytes = new byte[length];
        src.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static ByteBuffer wrapUTF8(String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 65535) {
            throw new IllegalArgumentException("UTF-8 encoded string must be less than 65536 bytes");
        }
        ByteBuffer result = ByteBuffer.allocate(bytes.length + 2);
        result.asShortBuffer().put((short)bytes.length);
        ((Buffer)result).position(result.position() + 2);
        result.put(bytes);
        ((Buffer)result).flip();
        return result;
    }

    public static ByteBuffer accumulate(ByteBuffer src, ByteBuffer dst) {
        if (dst.capacity() - dst.remaining() > src.remaining()) {
            int oldPosition = dst.position();
            ((Buffer)dst).position(dst.limit());
            ((Buffer)dst).limit(dst.limit() + src.remaining());
            dst.put(src);
            ((Buffer)dst).position(oldPosition);
            return dst;
        }
        ByteBuffer newDst = ByteBuffer.allocate((dst.remaining() + src.remaining()) * 2);
        newDst.put(dst);
        newDst.put(src);
        ((Buffer)newDst).flip();
        return newDst;
    }

    public static ByteBuffer duplicate(ByteBuffer buffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(buffer.remaining() * 2);
        newBuffer.put(buffer);
        ((Buffer)newBuffer).flip();
        return newBuffer;
    }
}

