/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.CommandTransport;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SynchronousCommandTransport
extends CommandTransport {
    protected Channel channel;
    private static final String RDR_SOCKET_TIMEOUT_PROPERTY_NAME = SynchronousCommandTransport.class.getName() + ".failOnSocketTimeoutInReader";
    private static boolean RDR_FAIL_ON_SOCKET_TIMEOUT = Boolean.getBoolean(RDR_SOCKET_TIMEOUT_PROPERTY_NAME);
    private static final Logger LOGGER = Logger.getLogger(SynchronousCommandTransport.class.getName());

    public abstract Command read() throws IOException, ClassNotFoundException, InterruptedException;

    @Override
    public void setup(Channel channel, CommandTransport.CommandReceiver receiver) {
        this.channel = channel;
        new ReaderThread(receiver).start();
    }

    private final class ReaderThread
    extends Thread {
        private final CommandTransport.CommandReceiver receiver;

        public ReaderThread(CommandTransport.CommandReceiver receiver) {
            super("Channel reader thread: " + SynchronousCommandTransport.this.channel.getName());
            this.receiver = receiver;
            this.setUncaughtExceptionHandler((t, e) -> {
                LOGGER.log(Level.SEVERE, e, () -> "Uncaught exception in SynchronousCommandTransport.ReaderThread " + String.valueOf(t));
                SynchronousCommandTransport.this.channel.terminate(new IOException("Unexpected reader termination", e));
            });
        }

        @Override
        public void run() {
            String name = SynchronousCommandTransport.this.channel.getName();
            try {
                while (!SynchronousCommandTransport.this.channel.isInClosed()) {
                    Command cmd;
                    try {
                        cmd = SynchronousCommandTransport.this.read();
                    }
                    catch (SocketTimeoutException ex) {
                        if (RDR_FAIL_ON_SOCKET_TIMEOUT) {
                            LOGGER.log(Level.SEVERE, ex, () -> "Socket timeout in the Synchronous channel reader. The channel will be interrupted, because " + RDR_SOCKET_TIMEOUT_PROPERTY_NAME + " is set");
                            throw ex;
                        }
                        LOGGER.log(Level.WARNING, "Socket timeout in the Synchronous channel reader", ex);
                        continue;
                    }
                    catch (EOFException e) {
                        throw new IOException("Unexpected termination of the channel", e);
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.log(Level.SEVERE, e, () -> "Unable to read a command (channel " + name + ")");
                        continue;
                    }
                    this.receiver.handle(cmd);
                }
                SynchronousCommandTransport.this.closeRead();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e, () -> "I/O error in channel " + name);
                Thread.currentThread().interrupt();
                SynchronousCommandTransport.this.channel.terminate((InterruptedIOException)new InterruptedIOException().initCause(e));
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, e, () -> "I/O error in channel " + name);
                SynchronousCommandTransport.this.channel.terminate(e);
            }
            catch (Error | RuntimeException e) {
                LOGGER.log(Level.SEVERE, e, () -> "Unexpected error in channel " + name);
                SynchronousCommandTransport.this.channel.terminate(new IOException("Unexpected reader termination", e));
                throw e;
            }
            finally {
                SynchronousCommandTransport.this.channel.pipeWriter.shutdown();
            }
        }
    }
}

