/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.instance_identity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

final class SelfSignedCertificate {
    private final KeyPair keyPair;
    private Date firstDate = new Date();
    private Date lastDate = new Date(this.firstDate.getTime() + TimeUnit.DAYS.toMillis(365L));
    private X500NameBuilder subject = new X500NameBuilder(BCStyle.INSTANCE);
    private String hashAlg = "SHA1";

    private SelfSignedCertificate(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public static SelfSignedCertificate forKeyPair(KeyPair keyPair) {
        return new SelfSignedCertificate(keyPair);
    }

    public SelfSignedCertificate validFrom(Date date) {
        this.firstDate = date == null ? new Date() : (Date)date.clone();
        return this;
    }

    public SelfSignedCertificate validUntil(Date date) {
        this.lastDate = date == null ? new Date(this.firstDate.getTime() + TimeUnit.DAYS.toMillis(365L)) : (Date)date.clone();
        return this;
    }

    public SelfSignedCertificate cn(String name) {
        this.subject.addRDN(BCStyle.CN, name);
        return this;
    }

    public SelfSignedCertificate c(String name) {
        this.subject.addRDN(BCStyle.C, name);
        return this;
    }

    public SelfSignedCertificate o(String name) {
        this.subject.addRDN(BCStyle.O, name);
        return this;
    }

    public SelfSignedCertificate ou(String name) {
        this.subject.addRDN(BCStyle.OU, name);
        return this;
    }

    public SelfSignedCertificate oid(String oid, String name) {
        this.subject.addRDN(new ASN1ObjectIdentifier(oid), name);
        return this;
    }

    public SelfSignedCertificate sha1() {
        this.hashAlg = "SHA1";
        return this;
    }

    public SelfSignedCertificate sha224() {
        this.hashAlg = "SHA224";
        return this;
    }

    public SelfSignedCertificate sha256() {
        this.hashAlg = "SHA256";
        return this;
    }

    public SelfSignedCertificate sha384() {
        this.hashAlg = "SHA384";
        return this;
    }

    public SelfSignedCertificate sha512() {
        this.hashAlg = "SHA512";
        return this;
    }

    public X509Certificate generate() throws IOException {
        try {
            ContentSigner signer;
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)this.keyPair.getPublic().getEncoded());
            X500Name subject = this.subject.build();
            X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(subject, BigInteger.ONE, this.firstDate, this.lastDate, subject, subjectPublicKeyInfo);
            JcaX509ExtensionUtils instance = new JcaX509ExtensionUtils();
            certGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)instance.createSubjectKeyIdentifier(subjectPublicKeyInfo));
            if (this.keyPair.getPrivate() instanceof RSAPrivateKey) {
                signer = new JcaContentSignerBuilder(this.hashAlg + "withRSA").build(this.keyPair.getPrivate());
            } else if (this.keyPair.getPrivate() instanceof DSAPrivateKey) {
                signer = new JcaContentSignerBuilder(this.hashAlg + "withDSA").build(this.keyPair.getPrivate());
            } else if (this.keyPair.getPrivate() instanceof ECPrivateKey) {
                signer = new JcaContentSignerBuilder(this.hashAlg + "withECDSA").build(this.keyPair.getPrivate());
            } else {
                throw new IOException("Unsupported key type");
            }
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certGen.build(signer).getEncoded()));
        }
        catch (OperatorCreationException e) {
            throw new IOException("Failed to generate a certificate", e);
        }
        catch (CertificateException e) {
            throw new IOException("Failed to generate a certificate", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Failed to generate a certificate", e);
        }
    }
}

