/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.modules.systemd_slave_installer;

import hudson.Extension;
import hudson.Util;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.jenkinsci.modules.slave_installer.SlaveInstaller;
import org.jenkinsci.modules.slave_installer.SlaveInstallerFactory;
import org.jenkinsci.modules.systemd_slave_installer.SystemdSlaveInstaller;

@Extension
public class SlaveInstallerFactoryImpl
extends SlaveInstallerFactory {
    @Inject
    InstanceIdentity id;

    public SlaveInstaller createIfApplicable(Channel c) throws IOException, InterruptedException {
        if (((Boolean)c.call((Callable)new HasSystemd())).booleanValue()) {
            RSAPublicKey key = this.id.getPublic();
            String instanceId = Util.getDigestOf((String)new String(Base64.encodeBase64((byte[])key.getEncoded()))).substring(0, 8);
            return new SystemdSlaveInstaller(instanceId);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HasSystemd
    implements Callable<Boolean, IOException> {
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = Logger.getLogger(HasSystemd.class.getName());

        private HasSystemd() {
        }

        public Boolean call() throws IOException {
            try {
                if (!new File("/etc/systemd/system").isDirectory()) {
                    return false;
                }
                Process p = new ProcessBuilder("systemctl", "list-units").redirectErrorStream(true).start();
                p.getOutputStream().close();
                this.drain(p.getInputStream());
                return p.waitFor() == 0;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "doesn't look like you have systemd but here is the details", e);
                return false;
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }

        private void drain(InputStream in) throws IOException {
            int len;
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) >= 0) {
            }
            in.close();
        }
    }
}

