/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerGlobalConfig;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerRunner;
import org.jenkinsci.plugins.ansible_tower.util.GetUserPageCredentials;
import org.jenkinsci.plugins.ansible_tower.util.TowerInstallation;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AnsibleTower
extends Builder {
    @Nonnull
    private String towerServer = "";
    @Nonnull
    private String jobTemplate = "";
    private String towerCredentialsId = "";
    private String extraVars = "";
    private String jobTags = "";
    private String skipJobTags = "";
    private String jobType = "run";
    private String limit = "";
    private String inventory = "";
    private String credential = "";
    private String scmBranch = "";
    private Boolean verbose = DescriptorImpl.verbose;
    private String importTowerLogs = "false";
    private Boolean removeColor = DescriptorImpl.removeColor;
    private String templateType = "job";
    private Boolean importWorkflowChildLogs = DescriptorImpl.importWorkflowChildLogs;

    public AnsibleTower(@Nonnull String towerServer, @Nonnull String jobTemplate, String towerCredentialsId, String jobType, String extraVars, String jobTags, String skipJobTags, String limit, String inventory, String credential, String scmBranch, Boolean verbose, Boolean importTowerLogs, Boolean removeColor, String templateType, Boolean importWorkflowChildLogs) {
        this.towerServer = towerServer;
        this.jobTemplate = jobTemplate;
        this.towerCredentialsId = towerCredentialsId;
        this.extraVars = extraVars;
        this.jobTags = jobTags;
        this.skipJobTags = skipJobTags;
        this.jobType = jobType;
        this.limit = limit;
        this.inventory = inventory;
        this.credential = credential;
        this.scmBranch = scmBranch;
        this.verbose = verbose;
        this.importTowerLogs = importTowerLogs.toString();
        this.removeColor = removeColor;
        this.templateType = templateType;
        this.importWorkflowChildLogs = importWorkflowChildLogs;
    }

    @DataBoundConstructor
    public AnsibleTower(@Nonnull String towerServer, @Nonnull String jobTemplate, String towerCredentialsId, String jobType, String extraVars, String jobTags, String skipJobTags, String limit, String inventory, String credential, String scmBranch, Boolean verbose, String importTowerLogs, Boolean removeColor, String templateType, Boolean importWorkflowChildLogs) {
        this.towerServer = towerServer;
        this.jobTemplate = jobTemplate;
        this.towerCredentialsId = towerCredentialsId;
        this.extraVars = extraVars;
        this.jobTags = jobTags;
        this.skipJobTags = skipJobTags;
        this.jobType = jobType;
        this.limit = limit;
        this.inventory = inventory;
        this.credential = credential;
        this.scmBranch = scmBranch;
        this.verbose = verbose;
        this.importTowerLogs = importTowerLogs;
        this.removeColor = removeColor;
        this.templateType = templateType;
        this.importWorkflowChildLogs = importWorkflowChildLogs;
    }

    @Nonnull
    public String getTowerServer() {
        return this.towerServer;
    }

    @Nonnull
    public String getJobTemplate() {
        return this.jobTemplate;
    }

    public String getTowerCredentialsId() {
        return this.towerCredentialsId;
    }

    public String getExtraVars() {
        return this.extraVars;
    }

    public String getJobTags() {
        return this.jobTags;
    }

    public String getSkipJobTags() {
        return this.skipJobTags;
    }

    public String getJobType() {
        return this.jobType;
    }

    public String getLimit() {
        return this.limit;
    }

    public String getInventory() {
        return this.inventory;
    }

    public String getCredential() {
        return this.credential;
    }

    public String getScmBranch() {
        return this.scmBranch;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public String getImportTowerLogs() {
        return this.importTowerLogs;
    }

    public Boolean getRemoveColor() {
        return this.removeColor;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public Boolean getImportWorkflowChildLogs() {
        return this.importWorkflowChildLogs;
    }

    @DataBoundSetter
    public void setTowerServer(String towerServer) {
        this.towerServer = towerServer;
    }

    @DataBoundSetter
    public void setJobTemplate(String jobTemplate) {
        this.jobTemplate = jobTemplate;
    }

    @DataBoundSetter
    public void setTowerCredentialsId(String towerCredentialsId) {
        this.towerCredentialsId = towerCredentialsId;
    }

    @DataBoundSetter
    public void setExtraVars(String extraVars) {
        this.extraVars = extraVars;
    }

    @DataBoundSetter
    public void setJobTags(String jobTags) {
        this.jobTags = jobTags;
    }

    @DataBoundSetter
    public void setSkipJobTags(String skipJobTags) {
        this.skipJobTags = skipJobTags;
    }

    @DataBoundSetter
    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    @DataBoundSetter
    public void setLimit(String limit) {
        this.limit = limit;
    }

    @DataBoundSetter
    public void setInventory(String inventory) {
        this.inventory = inventory;
    }

    @DataBoundSetter
    public void setCredential(String credential) {
        this.credential = credential;
    }

    @DataBoundSetter
    public void setScmBranch(String scmBranch) {
        this.scmBranch = scmBranch;
    }

    @DataBoundSetter
    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    @DataBoundSetter
    public void setImportTowerLogs(Boolean importTowerLogs) {
        this.importTowerLogs = importTowerLogs.toString();
    }

    @DataBoundSetter
    public void setImportTowerLogs(String importTowerLogs) {
        this.importTowerLogs = importTowerLogs;
    }

    @DataBoundSetter
    public void setRemoveColor(Boolean removeColor) {
        this.removeColor = removeColor;
    }

    @DataBoundSetter
    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    @DataBoundSetter
    public void setImportWorkflowChildLogs(Boolean importWorkflowChildLogs) {
        this.importWorkflowChildLogs = importWorkflowChildLogs;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean runResult;
        AnsibleTowerRunner runner = new AnsibleTowerRunner();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        String templateType = "job";
        if (this.getTemplateType() != null) {
            templateType = this.getTemplateType();
        }
        boolean importWorkflowChildLogs = false;
        if (this.getImportWorkflowChildLogs() != null) {
            importWorkflowChildLogs = this.getImportWorkflowChildLogs();
        }
        if (runResult = runner.runJobTemplate(listener.getLogger(), this.getTowerServer(), this.towerCredentialsId, this.getJobTemplate(), this.getJobType(), this.getExtraVars(), this.getLimit(), this.getJobTags(), this.getSkipJobTags(), this.getInventory(), this.getCredential(), this.getScmBranch(), this.verbose, this.importTowerLogs, this.getRemoveColor(), envVars, templateType, importWorkflowChildLogs, build.getWorkspace(), (Run<?, ?>)build, new Properties())) {
            build.setResult(Result.SUCCESS);
        } else {
            build.setResult(Result.FAILURE);
        }
        return runResult;
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final String towerServer = "";
        public static final String jobTemplate = "";
        public static final String towerCredentialsId = "";
        public static final String extraVars = "";
        public static final String limit = "";
        public static final String jobTags = "";
        public static final String skipJobTags = "";
        public static final String jobType = "run";
        public static final String inventory = "";
        public static final String credential = "";
        public static final String scmBranch = "";
        public static final Boolean verbose = false;
        public static final String importTowerLogs = "false";
        public static final Boolean removeColor = false;
        public static final String templateType = "job";
        public static final Boolean importWorkflowChildLogs = false;
        public static final Boolean throwExceptionWhenFail = true;
        public static final boolean async = false;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Ansible Tower";
        }

        public ListBoxModel doFillTowerServerItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(" - None -");
            for (TowerInstallation towerServer : AnsibleTowerGlobalConfig.get().getTowerInstallation()) {
                items.add(towerServer.getTowerDisplayName());
            }
            return items;
        }

        public ListBoxModel doFillTemplateTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(templateType);
            items.add("workflow");
            return items;
        }

        public ListBoxModel doFillJobTypeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(jobType);
            items.add("check");
            return items;
        }

        @POST
        public ListBoxModel doFillTowerCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String towerCredentialsId) {
            return GetUserPageCredentials.getUserAvailableCredentials(item, towerCredentialsId);
        }

        public ListBoxModel doFillImportTowerLogsItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Do not import", importTowerLogs);
            items.add("Import Truncated Logs", "true");
            items.add("Import Full Logs", "full");
            items.add("Process Variables Only", "vars");
            return items;
        }
    }
}

