/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower;

import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.util.XStream2;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.ansible_tower.util.TowerInstallation;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class AnsibleTowerGlobalConfig
extends GlobalConfiguration {
    private List<TowerInstallation> towerInstallations = new ArrayList<TowerInstallation>();
    private static final XStream2 XSTREAM2 = new XStream2();

    public AnsibleTowerGlobalConfig() {
        this.load();
    }

    protected XmlFile getConfigFile() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return null;
        }
        File rootDir = j.getRootDir();
        File xmlFile = new File(rootDir, "org.jenkinsci.plugins.ansible_tower.AnsibleTower.xml");
        return new XmlFile((XStream)XSTREAM2, xmlFile);
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    public static AnsibleTowerGlobalConfig get() {
        return (AnsibleTowerGlobalConfig)((Object)GlobalConfiguration.all().get(AnsibleTowerGlobalConfig.class));
    }

    public List<TowerInstallation> getTowerInstallation() {
        return this.towerInstallations;
    }

    public TowerInstallation getTowerInstallationByName(String name) {
        for (TowerInstallation installation : this.towerInstallations) {
            if (!installation.getTowerDisplayName().equals(name)) continue;
            return installation;
        }
        return null;
    }

    public void setTowerInstallation(List<TowerInstallation> towerInstallations) {
        this.towerInstallations = towerInstallations;
    }
}

