/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerGlobalConfig;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerRunner;
import org.jenkinsci.plugins.ansible_tower.util.GetUserPageCredentials;
import org.jenkinsci.plugins.ansible_tower.util.TowerInstallation;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AnsibleTowerProjectRevisionFreestyle
extends Builder {
    @Nonnull
    private String towerServer = "";
    private String towerCredentialsId = "";
    @Nonnull
    private String project = "";
    private String revision = "";
    private Boolean verbose = DescriptorImpl.verbose;
    private Boolean throwExceptionWhenFail = true;

    @DataBoundConstructor
    public AnsibleTowerProjectRevisionFreestyle(@Nonnull String towerServer, String towerCredentialsId, @Nonnull String project, String revision, Boolean verbose, Boolean throwExceptionWhenFail) {
        this.towerServer = towerServer;
        this.towerCredentialsId = towerCredentialsId;
        this.project = project;
        this.revision = revision;
        this.verbose = verbose;
        this.throwExceptionWhenFail = throwExceptionWhenFail;
    }

    @Nonnull
    public String getTowerServer() {
        return this.towerServer;
    }

    public String getTowerCredentialsId() {
        return this.towerCredentialsId;
    }

    @Nonnull
    public String getProject() {
        return this.project;
    }

    public String getRevision() {
        return this.revision;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public Boolean getThrowExceptionWhenFail() {
        return this.throwExceptionWhenFail;
    }

    @DataBoundSetter
    public void setTowerServer(String towerServer) {
        this.towerServer = towerServer;
    }

    @DataBoundSetter
    public void setTowerCredentialsId(String towerCredentialsId) {
        this.towerCredentialsId = towerCredentialsId;
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    @DataBoundSetter
    public void setRevision(String revision) {
        this.revision = revision;
    }

    @DataBoundSetter
    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    @DataBoundSetter
    public void setThrowExceptionWhenFail(Boolean throwExceptionWhenFail) {
        this.throwExceptionWhenFail = throwExceptionWhenFail;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        AnsibleTowerRunner runner = new AnsibleTowerRunner();
        EnvVars envVars = build.getEnvironment((TaskListener)listener);
        boolean runResult = runner.projectRevision(listener.getLogger(), this.getTowerServer(), this.getTowerCredentialsId(), this.project, this.revision, this.verbose, envVars, build.getWorkspace(), (Run<?, ?>)build, new Properties());
        if (runResult) {
            build.setResult(Result.SUCCESS);
        } else {
            build.setResult(Result.FAILURE);
        }
        return runResult;
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final String towerServer = "";
        public static final String towerCredentialsId = "";
        public static final String project = "";
        public static final String revision = "";
        public static final Boolean verbose = false;
        public static final Boolean throwExceptionWhenFail = true;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Ansible Tower Project Revision";
        }

        public ListBoxModel doFillTowerServerItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(" - None -");
            for (TowerInstallation towerServer : AnsibleTowerGlobalConfig.get().getTowerInstallation()) {
                items.add(towerServer.getTowerDisplayName());
            }
            return items;
        }

        @POST
        public ListBoxModel doFillTowerCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String towerCredentialsId) {
            return GetUserPageCredentials.getUserAvailableCredentials(item, towerCredentialsId);
        }
    }
}

