/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ansible_tower;

import com.google.inject.Inject;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerGlobalConfig;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerProjectRevisionFreestyle;
import org.jenkinsci.plugins.ansible_tower.AnsibleTowerRunner;
import org.jenkinsci.plugins.ansible_tower.util.GetUserPageCredentials;
import org.jenkinsci.plugins.ansible_tower.util.TowerInstallation;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AnsibleTowerProjectRevisionStep
extends AbstractStepImpl {
    private String towerServer = "";
    private String towerCredentialsId = "";
    private String project = "";
    private String revision = "";
    private Boolean verbose = false;
    private Boolean throwExceptionWhenFail = true;

    @DataBoundConstructor
    public AnsibleTowerProjectRevisionStep(@Nonnull String towerServer, @Nonnull String towerCredentialsId, @Nonnull String project, String revision, Boolean verbose, Boolean throwExceptionWhenFail) {
        this.towerServer = towerServer;
        this.towerCredentialsId = towerCredentialsId;
        this.project = project;
        this.revision = revision;
        this.verbose = verbose;
        this.throwExceptionWhenFail = throwExceptionWhenFail;
    }

    @Nonnull
    public String getTowerServer() {
        return this.towerServer;
    }

    public String getTowerCredentialsId() {
        return this.towerCredentialsId;
    }

    @Nonnull
    public String getProject() {
        return this.project;
    }

    public String getRevision() {
        return this.revision;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public Boolean getThrowExceptionWhenFail() {
        return this.throwExceptionWhenFail;
    }

    @DataBoundSetter
    public void setTowerServer(String towerServer) {
        this.towerServer = towerServer;
    }

    @DataBoundSetter
    public void setTowerCredentialsId(String towerCredentialsId) {
        this.towerCredentialsId = towerCredentialsId;
    }

    @DataBoundSetter
    public void setProject(String project) {
        this.project = project;
    }

    @DataBoundSetter
    public void setRevision(String revision) {
        this.revision = revision;
    }

    @DataBoundSetter
    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }

    @DataBoundSetter
    public void setThrowExceptionWhenFail(Boolean throwExceptionWhenFail) {
        this.throwExceptionWhenFail = throwExceptionWhenFail;
    }

    public static final class AnsibleTowerProjectRevisionStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Properties> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient AnsibleTowerProjectRevisionStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars envVars;
        @StepContextParameter
        private transient Computer computer;

        protected Properties run() throws AbortException {
            if (this.computer == null || this.computer.getNode() == null) {
                throw new AbortException("The Ansible Tower Project Revision build step requires to be launched on a node");
            }
            AnsibleTowerRunner runner = new AnsibleTowerRunner();
            String project = "";
            if (this.step.getProject() != null) {
                project = this.step.getProject();
            }
            String revision = "";
            if (this.step.getRevision() != null) {
                revision = this.step.getRevision();
            }
            boolean verbose = false;
            if (this.step.getVerbose() != null) {
                verbose = this.step.getVerbose();
            }
            boolean throwExceptionWhenFail = true;
            if (this.step.getThrowExceptionWhenFail() != null) {
                throwExceptionWhenFail = this.step.getThrowExceptionWhenFail();
            }
            Properties map = new Properties();
            boolean runResult = runner.projectRevision(this.listener.getLogger(), this.step.getTowerServer(), this.step.getTowerCredentialsId(), project, revision, verbose, this.envVars, this.ws, this.run, map);
            if (!runResult && throwExceptionWhenFail) {
                throw new AbortException("Ansible Tower Project Revision build step failed");
            }
            return map;
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public static final String towerServer = "";
        public static final String towerCredentialsId = "";
        public static final String project = "";
        public static final String revision = "";
        public static final Boolean verbose = AnsibleTowerProjectRevisionFreestyle.DescriptorImpl.verbose;
        public static final Boolean throwExceptionWhenFail = AnsibleTowerProjectRevisionFreestyle.DescriptorImpl.throwExceptionWhenFail;

        public DescriptorImpl() {
            super(AnsibleTowerProjectRevisionStepExecution.class);
        }

        public String getFunctionName() {
            return "ansibleTowerProjectRevision";
        }

        public String getDisplayName() {
            return "Have Ansible Tower update a Tower project's revision";
        }

        public ListBoxModel doFillTowerServerItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(" - None -");
            for (TowerInstallation towerServer : AnsibleTowerGlobalConfig.get().getTowerInstallation()) {
                items.add(towerServer.getTowerDisplayName());
            }
            return items;
        }

        @POST
        public ListBoxModel doFillTowerCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String towerCredentialsId) {
            return GetUserPageCredentials.getUserAvailableCredentials(item, towerCredentialsId);
        }
    }
}

