/*
 * Decompiled with CFR 0.152.
 */
package jenkins.authentication.tokens.api;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokenContext;
import jenkins.authentication.tokens.api.AuthenticationTokenException;
import jenkins.authentication.tokens.api.AuthenticationTokenSource;

public final class AuthenticationTokens {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationTokens.class.getName());

    private AuthenticationTokens() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> CredentialsMatcher matcher(Class<T> tokenClass) {
        return AuthenticationTokens.matcher(new AuthenticationTokenContext<T>(tokenClass));
    }

    public static <T> CredentialsMatcher matcher(AuthenticationTokenContext<T> context) {
        ArrayList<CredentialsMatcher> matchers = new ArrayList<CredentialsMatcher>();
        for (AuthenticationTokenSource source : ExtensionList.lookup(AuthenticationTokenSource.class)) {
            if (!source.fits(context)) continue;
            matchers.add(source.matcher());
        }
        return matchers.isEmpty() ? CredentialsMatchers.never() : CredentialsMatchers.anyOf((CredentialsMatcher[])matchers.toArray(new CredentialsMatcher[matchers.size()]));
    }

    @CheckForNull
    public static <T, C extends Credentials> T convert(@NonNull Class<T> type, @CheckForNull C credentials) {
        if (credentials == null) {
            return null;
        }
        return AuthenticationTokens.convert(new AuthenticationTokenContext<T>(type), credentials);
    }

    @CheckForNull
    public static <T, C extends Credentials> T convert(@NonNull AuthenticationTokenContext<T> context, @CheckForNull C credentials) {
        if (credentials == null) {
            return null;
        }
        TreeMap matches = new TreeMap(Collections.reverseOrder());
        for (AuthenticationTokenSource source : ExtensionList.lookup(AuthenticationTokenSource.class)) {
            Integer score = source.score(context, credentials);
            if (score == null || matches.containsKey(score)) continue;
            matches.put(score, source);
        }
        for (AuthenticationTokenSource source : matches.values()) {
            if (!source.produces(context.getTokenClass()) || !source.consumes(credentials)) continue;
            AuthenticationTokenSource s = source;
            T token = null;
            try {
                token = s.convert(credentials);
            }
            catch (AuthenticationTokenException e) {
                LogRecord lr = new LogRecord(Level.FINE, "Could not convert credentials {0} into token of type {1} using source {2}: {3}");
                lr.setThrown(e);
                lr.setParameters(new Object[]{credentials, context.getTokenClass(), s, e.getMessage()});
                LOGGER.log(lr);
            }
            if (token == null) continue;
            return token;
        }
        return null;
    }

    @CheckForNull
    public static <T, C extends Credentials> T convert(@NonNull AuthenticationTokenContext<T> context, C ... credentials) {
        return AuthenticationTokens.convert(context, Arrays.asList(credentials));
    }

    @CheckForNull
    public static <T, C extends Credentials> T convert(@NonNull AuthenticationTokenContext<T> context, @NonNull List<C> credentials) {
        TreeMap matches = new TreeMap(Collections.reverseOrder());
        for (Credentials credential : credentials) {
            for (AuthenticationTokenSource source : ExtensionList.lookup(AuthenticationTokenSource.class)) {
                Integer score = source.score(context, credential);
                if (score == null || matches.containsKey(score)) continue;
                matches.put(score, new AbstractMap.SimpleEntry<Credentials, AuthenticationTokenSource>(credential, source));
            }
        }
        for (Map.Entry entry : matches.values()) {
            AuthenticationTokenSource source;
            Credentials credential = (Credentials)entry.getKey();
            source = (AuthenticationTokenSource)entry.getValue();
            if (!source.produces(context.getTokenClass()) || !source.consumes(credential)) continue;
            AuthenticationTokenSource s = source;
            T token = null;
            try {
                token = s.convert(credential);
            }
            catch (AuthenticationTokenException e) {
                LogRecord lr = new LogRecord(Level.FINE, "Could not convert credentials {0} into token of type {1} using source {2}: {3}");
                lr.setThrown(e);
                lr.setParameters(new Object[]{credentials, context.getTokenClass(), s, e.getMessage()});
                LOGGER.log(lr);
            }
            if (token == null) continue;
            return token;
        }
        return null;
    }
}

