/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.util.FormValidation;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.branch.BranchIndexingCause;
import jenkins.branch.Messages;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@Restricted(value={NoExternalUse.class})
public class NoTriggerOrganizationFolderProperty
extends AbstractFolderProperty<OrganizationFolder> {
    private final String branches;

    @DataBoundConstructor
    public NoTriggerOrganizationFolderProperty(String branches) {
        this.branches = branches;
    }

    public String getBranches() {
        return this.branches;
    }

    @Extension
    public static class Dispatcher
    extends Queue.QueueDecisionHandler {
        public boolean shouldSchedule(Queue.Task p, List<Action> actions) {
            for (Action action : actions) {
                if (!(action instanceof CauseAction)) continue;
                for (Cause c : ((CauseAction)action).getCauses()) {
                    String name;
                    NoTriggerOrganizationFolderProperty prop;
                    MultiBranchProject mbp;
                    Job j;
                    if (!(c instanceof BranchIndexingCause) || !(p instanceof Job) || !((j = (Job)p).getParent() instanceof MultiBranchProject) || !((mbp = (MultiBranchProject)j.getParent()).getParent() instanceof OrganizationFolder) || (prop = (NoTriggerOrganizationFolderProperty)((OrganizationFolder)mbp.getParent()).getProperties().get(NoTriggerOrganizationFolderProperty.class)) == null || (name = mbp.getProjectFactory().getBranch(j).getName()).matches(prop.getBranches())) continue;
                    return false;
                }
            }
            return true;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        public String getDisplayName() {
            return Messages.NoTriggerBranchProperty_suppress_automatic_scm_triggering();
        }

        public FormValidation doCheckBranches(@QueryParameter String value) {
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException x) {
                return FormValidation.error((String)x.getMessage());
            }
        }
    }
}

