/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api;

import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import jenkins.authentication.tokens.api.AuthenticationTokenContext;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;

public interface BitbucketAuthenticator {
    public static final String SERVER_URL = "bitbucket.server.uri";
    public static final String SCHEME = "bitbucket.server.uri.scheme";
    public static final String BITBUCKET_INSTANCE_TYPE = "bitbucket.server.type";
    public static final String BITBUCKET_INSTANCE_TYPE_CLOUD = "BITBUCKET_CLOUD";
    public static final String BITBUCKET_INSTANCE_TYPE_SERVER = "BITBUCKET_SERVER";

    public String getId();

    default public void configureBuilder(HttpClientBuilder builder) {
    }

    default public void configureContext(HttpClientContext context, HttpHost host) {
    }

    default public void configureRequest(HttpRequest request) {
    }

    default public StandardUsernameCredentials getCredentialsForSCM() {
        return null;
    }

    public static AuthenticationTokenContext<BitbucketAuthenticator> authenticationContext(String serverURL) {
        if (serverURL == null) {
            serverURL = "https://bitbucket.org";
        }
        String scheme = serverURL.split(":")[0].toLowerCase();
        boolean isCloud = BitbucketApiUtils.isCloud(serverURL);
        return AuthenticationTokenContext.builder(BitbucketAuthenticator.class).with((Object)SERVER_URL, (Object)serverURL).with((Object)SCHEME, (Object)scheme).with((Object)BITBUCKET_INSTANCE_TYPE, (Object)(isCloud ? BITBUCKET_INSTANCE_TYPE_CLOUD : BITBUCKET_INSTANCE_TYPE_SERVER)).build();
    }
}

