/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.endpoint;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Describable;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public interface BitbucketEndpoint
extends Describable<BitbucketEndpoint> {
    @CheckForNull
    public String getDisplayName();

    @NonNull
    public String getRepositoryURL(@NonNull String var1, @NonNull String var2);

    @NonNull
    public EndpointType getType();

    @NonNull
    public String getServerURL();

    public boolean isManageHooks();

    @CheckForNull
    public String getCredentialsId();

    @CheckForNull
    public String getEndpointJenkinsRootURL();

    public boolean isEnableHookSignature();

    @CheckForNull
    public String getHookSignatureCredentialsId();

    @CheckForNull
    default public StandardCredentials credentials() {
        String credentialsId = Util.fixEmptyAndTrim((String)this.getCredentialsId());
        if (credentialsId == null) {
            return null;
        }
        return BitbucketCredentials.lookupCredentials(this.getServerURL(), Jenkins.get(), credentialsId, StandardCredentials.class);
    }

    @CheckForNull
    default public StringCredentials hookSignatureCredentials() {
        String credentialsId = Util.fixEmptyAndTrim((String)this.getHookSignatureCredentialsId());
        if (credentialsId == null) {
            return null;
        }
        return BitbucketCredentials.lookupCredentials(this.getServerURL(), Jenkins.get(), credentialsId, StringCredentials.class);
    }

    default public boolean isEquals(BitbucketEndpoint endpoint) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.getServerURL(), (CharSequence)endpoint.getServerURL());
    }

    public BitbucketEndpointDescriptor getDescriptor();
}

