/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudWebhookPayload;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.PushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerWebhookPayload;
import hudson.RestrictedSince;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="933.3.0")
public class PushHookProcessor
extends HookProcessor {
    private static final Logger LOGGER = Logger.getLogger(PushHookProcessor.class.getName());

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin) {
        BitbucketPushEvent push;
        if (payload != null && (push = instanceType == BitbucketType.SERVER ? BitbucketServerWebhookPayload.pushEventFromPayload(payload) : BitbucketCloudWebhookPayload.pushEventFromPayload(payload)) != null) {
            if (push.getChanges().isEmpty()) {
                String owner = push.getRepository().getOwnerName();
                String repository = push.getRepository().getRepositoryName();
                if (instanceType == BitbucketType.CLOUD || SCAN_ON_EMPTY_CHANGES) {
                    LOGGER.log(Level.INFO, "Received push hook with empty changes from Bitbucket. Processing indexing on {0}/{1}. You may skip this scan by adding the system property -D{2}=false on startup.", new Object[]{owner, repository, "bitbucket.hooks.processor.scanOnEmptyChanges"});
                    this.scmSourceReIndex(owner, repository, null);
                } else {
                    LOGGER.log(Level.INFO, "Received push hook with empty changes from Bitbucket for {0}/{1}. Skipping.", new Object[]{owner, repository});
                }
            } else {
                SCMEvent.Type type = null;
                for (BitbucketPushEvent.Change change : push.getChanges()) {
                    if ((type == null || type == SCMEvent.Type.CREATED) && change.isCreated()) {
                        type = SCMEvent.Type.CREATED;
                        continue;
                    }
                    if ((type == null || type == SCMEvent.Type.REMOVED) && change.isClosed()) {
                        type = SCMEvent.Type.REMOVED;
                        continue;
                    }
                    type = SCMEvent.Type.UPDATED;
                }
                this.notifyEvent(new PushEvent(type, push, origin), BitbucketSCMSource.getEventDelaySeconds());
            }
        }
    }
}

