/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.SAFE)
public class ExponentialBackoffRetryStrategy
extends DefaultHttpRequestRetryStrategy {
    public static final long DEFAULT_BACK_OFF_RATE = 10L;
    public static final long DEFAULT_INITIAL_EXPIRY_IN_MILLIS = TimeUnit.SECONDS.toMillis(6L);
    public static final long DEFAULT_MAX_EXPIRY_IN_MILLIS = TimeUnit.SECONDS.toMillis(86400L);
    private final long backOffRate;
    private final long initialExpiryInMillis;
    private final long maxExpiryInMillis;
    private final Set<Class<? extends IOException>> nonRetriableIOExceptionClasses;

    public ExponentialBackoffRetryStrategy() {
        this(10L, DEFAULT_INITIAL_EXPIRY_IN_MILLIS, DEFAULT_MAX_EXPIRY_IN_MILLIS);
    }

    public ExponentialBackoffRetryStrategy(long backOffRate, long initialExpiryInMillis, long maxExpiryInMillis) {
        this.backOffRate = Args.notNegative((long)backOffRate, (String)"BackOffRate");
        this.initialExpiryInMillis = Args.notNegative((long)initialExpiryInMillis, (String)"InitialExpiryInMillis");
        this.maxExpiryInMillis = Args.notNegative((long)maxExpiryInMillis, (String)"MaxExpiryInMillis");
        this.nonRetriableIOExceptionClasses = Set.of(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, ConnectionClosedException.class, NoRouteToHostException.class, SSLException.class);
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        int statusCode = response.getCode();
        return this.getRetryInterval(executionCount) < this.maxExpiryInMillis && (statusCode == 429 || statusCode == 503);
    }

    private long getRetryInterval(int failedAttempts) {
        if (failedAttempts > 0) {
            long delayInSeconds = (long)((double)this.initialExpiryInMillis * Math.pow(this.backOffRate, failedAttempts - 1));
            return Math.min(delayInSeconds, this.maxExpiryInMillis);
        }
        return 0L;
    }

    public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        CancellableDependency cancellable;
        if (this.nonRetriableIOExceptionClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableIOExceptionClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        if (request instanceof CancellableDependency && (cancellable = (CancellableDependency)request).isCancelled()) {
            return false;
        }
        return this.handleAsIdempotent(request);
    }

    public TimeValue getRetryInterval(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        return TimeValue.ofMilliseconds((long)this.getRetryInterval(execCount));
    }

    public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
        Header header = response.getFirstHeader("Retry-After");
        TimeValue retryAfter = null;
        if (header != null) {
            block4: {
                String value = header.getValue();
                try {
                    retryAfter = TimeValue.ofSeconds((long)Long.parseLong(value));
                }
                catch (NumberFormatException ignore) {
                    Instant retryAfterDate = DateUtils.parseStandardDate((String)value);
                    if (retryAfterDate == null) break block4;
                    retryAfter = TimeValue.ofMilliseconds((long)(retryAfterDate.toEpochMilli() - System.currentTimeMillis()));
                }
            }
            if (TimeValue.isPositive((TimeValue)retryAfter)) {
                return retryAfter;
            }
        }
        return TimeValue.ofMilliseconds((long)this.getRetryInterval(execCount));
    }
}

