/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.credentials;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketException;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import hudson.util.Secret;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;

public class BitbucketClientCertificateAuthenticator
implements BitbucketAuthenticator {
    private static final Logger logger = Logger.getLogger(BitbucketClientCertificateAuthenticator.class.getName());
    private static final String SOCKET_FACTORY_REGISTRY = "http.socket-factory-registry";
    private final String credentialsId;
    private final KeyStore keyStore;
    private final Secret password;

    public BitbucketClientCertificateAuthenticator(StandardCertificateCredentials credentials) {
        this.credentialsId = credentials.getId();
        this.keyStore = credentials.getKeyStore();
        this.password = credentials.getPassword();
    }

    @Override
    public void configureContext(HttpClientContext context, HttpHost host) {
        try {
            Registry registry = RegistryBuilder.create().register(URIScheme.HTTP.id, (Object)PlainConnectionSocketFactory.getSocketFactory()).register(URIScheme.HTTPS.id, (Object)new SSLConnectionSocketFactory(this.buildSSLContext(), HttpsSupport.getDefaultHostnameVerifier())).build();
            context.setAttribute(SOCKET_FACTORY_REGISTRY, (Object)registry);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new BitbucketException("Failed to set up SSL context from provided client certificate", e);
        }
    }

    private SSLContext buildSSLContext() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        SSLContextBuilder contextBuilder = SSLContexts.custom();
        contextBuilder.loadKeyMaterial(this.keyStore, Secret.toString((Secret)this.password).toCharArray());
        return contextBuilder.build();
    }

    @Override
    public String getId() {
        return this.credentialsId;
    }
}

