/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.extension;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentials;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Item;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.Objects;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.core.Authentication;

public class GitClientAuthenticatorExtension
extends GitSCMExtension {
    @Deprecated
    private transient StandardUsernameCredentials credentials;
    private final String url;
    private final String serverURL;
    private final String scmOwner;
    private final String credentialsId;

    @Deprecated(since="936.0.0", forRemoval=true)
    public GitClientAuthenticatorExtension(String url, StandardUsernameCredentials credentials) {
        this.url = url;
        this.credentialsId = credentials != null ? credentials.getId() : null;
        this.credentials = credentials;
        this.serverURL = null;
        this.scmOwner = null;
    }

    @DataBoundConstructor
    public GitClientAuthenticatorExtension(@NonNull String url, @NonNull String serverURL, @CheckForNull String scmOwner, @Nullable String credentialsId) {
        this.url = url;
        this.serverURL = serverURL;
        this.scmOwner = scmOwner;
        this.credentialsId = credentialsId;
    }

    public GitClient decorate(GitSCM scm, GitClient git) throws GitException {
        StandardUsernameCredentials credentials = this.credentials;
        if (this.credentialsId != null) {
            BitbucketAuthenticator authenticator = this.authenticator();
            if (authenticator == null) {
                throw new IllegalStateException("No credentialsId " + this.getCredentialsId() + " found for project " + this.scmOwner + " and server " + this.serverURL);
            }
            credentials = authenticator.getCredentialsForSCM();
        }
        if (credentials != null) {
            if (this.url == null) {
                git.setCredentials(credentials);
            } else {
                git.addCredentials(this.url, (StandardCredentials)credentials);
            }
        }
        return git;
    }

    @CheckForNull
    private BitbucketAuthenticator authenticator() {
        StandardCredentials credentials;
        if (this.serverURL == null) {
            throw new IllegalStateException("Some required data are missing, perform a 'Scan project Now' action to refresh old data");
        }
        if (this.scmOwner != null) {
            Item owner = null;
            try (ACLContext as = ACL.as2((Authentication)ACL.SYSTEM2);){
                owner = Jenkins.get().getItemByFullName(this.scmOwner, Item.class);
            }
            if (owner == null) {
                throw new IllegalStateException("Item " + this.scmOwner + " seems to be relocated, perform a 'Scan project Now' action to refresh old data");
            }
            credentials = BitbucketCredentials.lookupCredentials(this.serverURL, owner, this.credentialsId, StandardCredentials.class);
        } else {
            credentials = BitbucketCredentials.lookupCredentials(this.serverURL, Jenkins.get(), this.credentialsId, StandardCredentials.class);
        }
        return (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.serverURL), (Credentials)credentials);
    }

    @Deprecated(since="936.0.0", forRemoval=true)
    public StandardUsernameCredentials getCredentials() {
        return this.credentials;
    }

    public String getUrl() {
        return this.url;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getScmOwner() {
        return this.scmOwner;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public int hashCode() {
        return Objects.hash(this.url, this.serverURL, this.scmOwner, this.credentialsId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GitClientAuthenticatorExtension other = (GitClientAuthenticatorExtension)((Object)obj);
        return Objects.equals(this.credentialsId, other.credentialsId) && Objects.equals(this.serverURL, other.serverURL) && Objects.equals(this.scmOwner, other.scmOwner) && Objects.equals(this.url, other.url);
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Translated git client credentials.";
        }
    }
}

