/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.util;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceOwner;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;

public class BitbucketCredentials {
    private BitbucketCredentials() {
        throw new IllegalAccessError("Utility class");
    }

    @CheckForNull
    public static <T extends StandardCredentials> T lookupCredentials(@CheckForNull String serverURL, @CheckForNull Item item, @CheckForNull String id, @NonNull Class<T> type) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            Authentication authentication;
            if (item instanceof Queue.Task) {
                Queue.Task task = (Queue.Task)item;
                authentication = task.getDefaultAuthentication2();
            } else {
                authentication = ACL.SYSTEM2;
            }
            Authentication authentication2 = authentication;
            return (T)((StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(type, (Item)item, (Authentication)authentication2, (List)URIRequirementBuilder.fromUri((String)serverURL).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)id), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(type)})})));
        }
        return null;
    }

    @CheckForNull
    public static <T extends StandardCredentials> T lookupCredentials(@CheckForNull String serverURL, @CheckForNull ItemGroup<?> itemGroup, @CheckForNull String id, @NonNull Class<T> type) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return (T)((StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(type, itemGroup, null, (List)URIRequirementBuilder.fromUri((String)serverURL).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)id), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(type)})})));
        }
        return null;
    }

    public static ListBoxModel fillCredentialsIdItems(SCMSourceOwner context, String serverURL) {
        Authentication authentication;
        Jenkins contextToCheck;
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeEmptyValue();
        Object object = contextToCheck = context == null ? Jenkins.get() : context;
        if (!contextToCheck.hasPermission(CredentialsProvider.VIEW)) {
            return result;
        }
        if (context instanceof Queue.Task) {
            Queue.Task task = (Queue.Task)context;
            authentication = task.getDefaultAuthentication2();
        } else {
            authentication = ACL.SYSTEM2;
        }
        Authentication authentication2 = authentication;
        serverURL = BitbucketEndpointProvider.lookupEndpoint(serverURL).orElse(BitbucketEndpointConfiguration.get().getDefaultEndpoint()).getServerURL();
        result.includeMatchingAs(authentication2, (Item)context, StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverURL).build(), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(serverURL)));
        return result;
    }

    public static FormValidation checkCredentialsId(@CheckForNull SCMSourceOwner context, String value, String serverURL) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Authentication authentication;
            serverURL = BitbucketEndpointProvider.lookupEndpoint(serverURL).orElse(BitbucketEndpointConfiguration.get().getDefaultEndpoint()).getServerURL();
            Jenkins contextToCheck = context == null ? Jenkins.get() : context;
            contextToCheck.checkPermission(CredentialsProvider.VIEW);
            if (context instanceof Queue.Task) {
                Queue.Task task = (Queue.Task)context;
                v0 = task.getDefaultAuthentication2();
            } else {
                v0 = authentication = ACL.SYSTEM2;
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardCertificateCredentials.class, (Item)context, (Authentication)authentication, (List)URIRequirementBuilder.fromUri((String)serverURL).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)value), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(serverURL))})) != null) {
                return FormValidation.warning((String)"A certificate was selected. You will likely need to configure Checkout over SSH.");
            }
            return FormValidation.ok();
        }
        return FormValidation.warning((String)"Credentials are required for build notifications");
    }

    public static ListBoxModel fillCredentialsIdItems(@CheckForNull String serverURL, @NonNull ItemGroup<?> context, @NonNull Class<? extends StandardCredentials> type, @CheckForNull String credentialsId) {
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeMatchingAs(ACL.SYSTEM2, context, type, URIRequirementBuilder.fromUri((String)serverURL).build(), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(serverURL)));
        if (credentialsId != null) {
            result.includeCurrentValue(credentialsId);
        }
        return result;
    }
}

