/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.server.client;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketMirrorServer;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketMirroredRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketMirroredRepositoryDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import com.cloudbees.jenkins.plugins.bitbucket.impl.client.AbstractBitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketAccessTokenAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketClientCertificateAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketUsernamePasswordAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerVersion;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerWebhookImplementation;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.PagedApiResponse;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerBranch;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerBranches;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerBuildStatus;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerCommit;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest.BitbucketServerPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest.BitbucketServerPullRequestCanMerge;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerProject;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerWebhooks;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.NativeBitbucketServerWebhook;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.impl.Operator;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import jenkins.scm.api.SCMFile;
import jenkins.scm.impl.avatars.AvatarImage;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class BitbucketServerAPIClient
extends AbstractBitbucketApi
implements BitbucketApi {
    private static final int MAX_AVATAR_LENGTH = 16384;
    private static final String API_BASE_PATH = "/rest/api/1.0";
    private static final String API_REPOSITORIES_PATH = "/rest/api/1.0/projects/{owner}/repos{?start,limit}";
    private static final String API_REPOSITORY_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}";
    private static final String API_DEFAULT_BRANCH_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/branches/default";
    private static final String API_BRANCHES_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/branches{?start,limit}";
    private static final String API_BRANCHES_FILTERED_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/branches{?filterText,start,limit}";
    private static final String API_TAGS_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/tags{?start,limit}";
    private static final String API_TAG_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/tags/{tagName}";
    private static final String API_PULL_REQUESTS_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/pull-requests{?start,limit,at,direction,state}";
    private static final String API_PULL_REQUEST_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/pull-requests/{id}";
    private static final String API_PULL_REQUEST_MERGE_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/pull-requests/{id}/merge";
    private static final String API_PULL_REQUEST_CHANGES_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/pull-requests/{id}/changes{?start,limit}";
    private static final String API_BROWSE_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/browse{/path*}{?at}";
    private static final String API_PROJECT_PATH = "/rest/api/1.0/projects/{owner}";
    private static final String AVATAR_PATH = "/rest/api/1.0/projects/{owner}/avatar.png";
    private static final String API_WEBHOOKS_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/webhooks{/id}{?start,limit}";
    private static final String API_COMMITS_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/commits{?since,until,merges,start,limit}";
    private static final String API_COMMIT_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/commits{/hash}";
    private static final String API_COMMIT_COMMENT_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/commits{/hash}/comments";
    private static final String API_COMMIT_STATUS_PATH = "/rest/api/1.0/projects/{owner}/repos/{repo}/commits/{hash}/builds";
    private static final String WEBHOOK_BASE_PATH = "/rest/webhook/1.0";
    private static final String WEBHOOK_REPOSITORY_PATH = "/rest/webhook/1.0/projects/{owner}/repos/{repo}/configurations";
    private static final String WEBHOOK_REPOSITORY_CONFIG_PATH = "/rest/webhook/1.0/projects/{owner}/repos/{repo}/configurations/{id}";
    private static final String API_MIRRORS_FOR_REPO_PATH = "/rest/mirroring/1.0/repos/{id}/mirrors";
    private static final String API_MIRRORS_PATH = "/rest/mirroring/1.0/mirrorServers";
    private static final Integer DEFAULT_PAGE_LIMIT = 200;
    private static final HttpClientConnectionManager connectionManager = BitbucketServerAPIClient.connectionManagerBuilder().setMaxConnPerRoute(20).setMaxConnTotal(40).build();
    private final String owner;
    private final String repositoryName;
    private final boolean userCentric;
    private final String baseURL;
    private final BitbucketServerWebhookImplementation webhookImplementation;
    private final CloseableHttpClient client;

    public BitbucketServerAPIClient(@NonNull String baseURL, @NonNull String owner, @CheckForNull String repositoryName, @CheckForNull BitbucketAuthenticator authenticator, boolean userCentric) {
        this(baseURL, owner, repositoryName, authenticator, userCentric, BitbucketServerEndpoint.findWebhookImplementation(baseURL));
    }

    public BitbucketServerAPIClient(@NonNull String baseURL, @NonNull String owner, @CheckForNull String repositoryName, @CheckForNull BitbucketAuthenticator authenticator, boolean userCentric, @NonNull BitbucketServerWebhookImplementation webhookImplementation) {
        super(authenticator);
        this.userCentric = userCentric;
        this.owner = Util.fixEmptyAndTrim((String)owner);
        if (this.owner == null) {
            throw new IllegalArgumentException("owner can not be null");
        }
        this.repositoryName = repositoryName;
        this.baseURL = Util.removeTrailingSlash((String)baseURL);
        this.webhookImplementation = Objects.requireNonNull(webhookImplementation);
        this.client = this.setupClientBuilder().build();
    }

    @Override
    protected boolean isSupportedAuthenticator(@CheckForNull BitbucketAuthenticator authenticator) {
        return authenticator == null || authenticator instanceof BitbucketClientCertificateAuthenticator || authenticator instanceof BitbucketAccessTokenAuthenticator || authenticator instanceof BitbucketUsernamePasswordAuthenticator;
    }

    @Override
    @NonNull
    public String getOwner() {
        return this.owner;
    }

    public String getUserCentricOwner() {
        return this.userCentric ? "~" + this.owner : this.owner;
    }

    @Override
    @CheckForNull
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @NonNull
    public List<BitbucketServerPullRequest> getPullRequests() throws IOException {
        UriTemplate template = UriTemplate.fromTemplate((String)(this.baseURL + API_PULL_REQUESTS_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName);
        return this.getPullRequests(template);
    }

    @NonNull
    public List<BitbucketServerPullRequest> getOutgoingOpenPullRequests(String fromRef) throws IOException {
        UriTemplate template = UriTemplate.fromTemplate((String)(this.baseURL + API_PULL_REQUESTS_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("at", (Object)fromRef).set("direction", (Object)"outgoing").set("state", (Object)"OPEN");
        return this.getPullRequests(template);
    }

    @NonNull
    public List<BitbucketServerPullRequest> getIncomingOpenPullRequests(String toRef) throws IOException {
        UriTemplate template = UriTemplate.fromTemplate((String)(this.baseURL + API_PULL_REQUESTS_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("at", (Object)toRef).set("direction", (Object)"incoming").set("state", (Object)"OPEN");
        return this.getPullRequests(template);
    }

    private List<BitbucketServerPullRequest> getPullRequests(UriTemplate template) throws IOException {
        List<BitbucketServerPullRequest> pullRequests = this.getPagedRequest(template, BitbucketServerPullRequest.class);
        pullRequests.removeIf(this::shouldIgnore);
        BitbucketServerEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint(this.baseURL, BitbucketServerEndpoint.class).orElse(null);
        for (BitbucketServerPullRequest pullRequest : pullRequests) {
            this.setupPullRequest(pullRequest, endpoint);
        }
        if (endpoint != null && endpoint.isCallChanges() && BitbucketServerVersion.VERSION_7.equals((Object)endpoint.getServerVersion())) {
            pullRequests = this.getPagedRequest(template, BitbucketServerPullRequest.class);
            pullRequests.removeIf(this::shouldIgnore);
        }
        return pullRequests;
    }

    private void setupPullRequest(@NonNull BitbucketServerPullRequest pullRequest, @Nullable BitbucketServerEndpoint endpoint) throws IOException {
        this.setupClosureForPRBranch(pullRequest);
        if (endpoint != null) {
            if (endpoint.isCallCanMerge()) {
                try {
                    pullRequest.setCanMerge(this.getPullRequestCanMergeById(pullRequest.getId()));
                }
                catch (BitbucketRequestException e) {
                    if (e.getHttpCode() == 409) {
                        pullRequest.setCanMerge(false);
                    }
                    throw e;
                }
            }
            if (endpoint.isCallChanges() && BitbucketServerVersion.VERSION_7.equals((Object)endpoint.getServerVersion())) {
                this.callPullRequestChangesById(pullRequest.getId());
            }
        }
    }

    private boolean shouldIgnore(BitbucketPullRequest pullRequest) {
        return pullRequest.getSource().getRepository() == null || pullRequest.getSource().getBranch() == null || pullRequest.getDestination().getBranch() == null;
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="TODO needs triage")
    private void setupClosureForPRBranch(@NonNull BitbucketServerPullRequest pr) {
        try {
            BitbucketServerBranch branch = (BitbucketServerBranch)pr.getSource().getBranch();
            if (branch != null) {
                branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
            }
            if ((branch = (BitbucketServerBranch)pr.getDestination().getBranch()) != null) {
                branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
            }
        }
        catch (NullPointerException e) {
            this.logger.log(Level.SEVERE, "setupClosureForPRBranch", e);
        }
    }

    private void callPullRequestChangesById(@NonNull String id) throws IOException {
        String url = UriTemplate.fromTemplate((String)(this.baseURL + API_PULL_REQUEST_CHANGES_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)id).set("limit", (Object)1).expand();
        this.getRequest(url);
    }

    private boolean getPullRequestCanMergeById(@NonNull String id) throws IOException {
        String url = UriTemplate.fromTemplate((String)(this.baseURL + API_PULL_REQUEST_MERGE_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)id).expand();
        return this.getRequestAs(url, BitbucketServerPullRequestCanMerge.class).isCanMerge();
    }

    @Override
    @NonNull
    public BitbucketPullRequest getPullRequestById(@NonNull Integer id) throws IOException {
        String url = UriTemplate.fromTemplate((String)(this.baseURL + API_PULL_REQUEST_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)id).expand();
        String response = this.getRequest(url);
        BitbucketServerPullRequest pr = JsonParser.toJava(response, BitbucketServerPullRequest.class);
        this.setupClosureForPRBranch(pr);
        BitbucketServerEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint(this.baseURL, BitbucketServerEndpoint.class).orElse(null);
        this.setupPullRequest(pr, endpoint);
        return pr;
    }

    @Override
    @NonNull
    public BitbucketRepository getRepository() throws IOException {
        if (this.repositoryName == null) {
            throw new UnsupportedOperationException("Cannot get a repository from an API instance that is not associated with a repository");
        }
        String url = UriTemplate.fromTemplate((String)(this.baseURL + API_REPOSITORY_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).expand();
        String response = this.getRequest(url);
        return JsonParser.toJava(response, BitbucketServerRepository.class);
    }

    @NonNull
    public List<BitbucketMirrorServer> getMirrors() throws IOException {
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)(this.baseURL + API_MIRRORS_PATH));
        return this.getPagedRequest(uriTemplate, BitbucketMirrorServer.class);
    }

    @NonNull
    public List<BitbucketMirroredRepositoryDescriptor> getMirrors(@NonNull Long repositoryId) throws IOException {
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)(this.baseURL + API_MIRRORS_FOR_REPO_PATH)).set("id", (Object)repositoryId);
        return this.getPagedRequest(uriTemplate, BitbucketMirroredRepositoryDescriptor.class);
    }

    @NonNull
    public BitbucketMirroredRepository getMirroredRepository(@NonNull String url) throws IOException {
        return this.getRequestAs(url, BitbucketMirroredRepository.class);
    }

    @Override
    public void postCommitComment(@NonNull String hash, @NonNull String comment) throws IOException {
        this.postRequest(UriTemplate.fromTemplate((String)(this.baseURL + API_COMMIT_COMMENT_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("hash", (Object)hash).expand(), Collections.singletonList(new BasicNameValuePair("text", comment)));
    }

    @Override
    public void postBuildStatus(@NonNull BitbucketBuildStatus status) throws IOException {
        BitbucketServerBuildStatus newStatus = new BitbucketServerBuildStatus(status);
        newStatus.setName(StringUtils.abbreviate((String)newStatus.getName(), (int)255));
        String key = status.getKey();
        if (StringUtils.length((CharSequence)key) > 255) {
            newStatus.setKey(StringUtils.substring((String)key, (int)0, (int)222) + "/" + DigestUtils.md5Hex((String)key));
        }
        String url = UriTemplate.fromTemplate((String)(this.baseURL + API_COMMIT_STATUS_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("hash", (Object)newStatus.getHash()).expand();
        this.postRequest(url, JsonParser.toJson(newStatus));
    }

    @Override
    public boolean checkPathExists(@NonNull String branchOrHash, @NonNull String path) throws IOException {
        String url = UriTemplate.fromTemplate((String)(this.baseURL + API_BROWSE_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("path", (Object)path.split(Operator.PATH.getSeparator())).set("at", (Object)branchOrHash).expand();
        int status = this.headRequestStatus(url);
        if (200 == status) {
            return true;
        }
        if (404 == status || 401 == status) {
            return false;
        }
        throw new IOException("Communication error, requested URL: " + path + " status code: " + status);
    }

    @Override
    @CheckForNull
    public String getDefaultBranch() throws IOException {
        String url = UriTemplate.fromTemplate((String)(this.baseURL + API_DEFAULT_BRANCH_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).expand();
        try {
            return this.getRequestAs(url, BitbucketServerBranch.class).getName();
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.FINE, "Could not find default branch for {0}/{1}", new Object[]{this.owner, this.repositoryName});
            return null;
        }
    }

    @Override
    public BitbucketServerBranch getTag(@NonNull String tagName) throws IOException {
        String url = UriTemplate.fromTemplate((String)(this.baseURL + API_TAG_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("tagName", (Object)tagName).expand().replace("%2F", "/");
        BitbucketServerBranch tag = this.getRequestAs(url, BitbucketServerBranch.class);
        if (tag != null) {
            tag.setCommitClosure(new CommitClosure(tag.getRawNode()));
        }
        return tag;
    }

    @NonNull
    public List<BitbucketServerBranch> getTags() throws IOException {
        return this.getServerBranches(API_TAGS_PATH);
    }

    @Override
    public BitbucketServerBranch getBranch(@NonNull String branchName) throws IOException {
        return this.getSingleBranch(branchName);
    }

    @NonNull
    public List<BitbucketServerBranch> getBranches() throws IOException {
        return this.getServerBranches(API_BRANCHES_PATH);
    }

    private List<BitbucketServerBranch> getServerBranches(String apiPath) throws IOException {
        UriTemplate template = UriTemplate.fromTemplate((String)(this.baseURL + apiPath)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName);
        List<BitbucketServerBranch> branches = this.getPagedRequest(template, BitbucketServerBranch.class);
        for (BitbucketServerBranch branch : branches) {
            if (branch == null) continue;
            branch.setCommitClosure(new CommitClosure(branch.getRawNode()));
        }
        return branches;
    }

    private BitbucketServerBranch getSingleBranch(String branchName) throws IOException {
        UriTemplate template = UriTemplate.fromTemplate((String)(this.baseURL + API_BRANCHES_FILTERED_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("filterText", (Object)branchName);
        BitbucketServerBranch br = this.getResource(template, BitbucketServerBranches.class, branch -> branchName.equals(branch.getName()));
        if (br != null) {
            br.setCommitClosure(new CommitClosure(br.getRawNode()));
        }
        return br;
    }

    @Override
    @NonNull
    public BitbucketCommit resolveCommit(@NonNull String hash) throws IOException {
        String url = UriTemplate.fromTemplate((String)(this.baseURL + API_COMMIT_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("hash", (Object)hash).expand();
        return this.getRequestAs(url, BitbucketServerCommit.class);
    }

    @Override
    @NonNull
    public String resolveSourceFullHash(@NonNull BitbucketPullRequest pull) {
        return pull.getSource().getCommit().getHash();
    }

    @Override
    @NonNull
    public BitbucketCommit resolveCommit(@NonNull BitbucketPullRequest pull) throws IOException {
        return this.resolveCommit(this.resolveSourceFullHash(pull));
    }

    @Override
    public void registerCommitWebHook(BitbucketWebHook hook) throws IOException {
        switch (this.webhookImplementation) {
            case PLUGIN: {
                this.putRequest(UriTemplate.fromTemplate((String)(this.baseURL + WEBHOOK_REPOSITORY_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).expand(), JsonParser.toJson(hook));
                break;
            }
            case NATIVE: {
                this.postRequest(UriTemplate.fromTemplate((String)(this.baseURL + API_WEBHOOKS_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).expand(), JsonParser.toJson(hook));
                break;
            }
            default: {
                this.logger.log(Level.WARNING, "Cannot register {0} webhook.", (Object)this.webhookImplementation);
            }
        }
    }

    @Override
    public void updateCommitWebHook(BitbucketWebHook hook) throws IOException {
        switch (this.webhookImplementation) {
            case PLUGIN: {
                this.postRequest(UriTemplate.fromTemplate((String)(this.baseURL + WEBHOOK_REPOSITORY_CONFIG_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)hook.getUuid()).expand(), JsonParser.toJson(hook));
                break;
            }
            case NATIVE: {
                this.putRequest(UriTemplate.fromTemplate((String)(this.baseURL + API_WEBHOOKS_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)hook.getUuid()).expand(), JsonParser.toJson(hook));
                break;
            }
            default: {
                this.logger.log(Level.WARNING, "Cannot update {0} webhook.", (Object)this.webhookImplementation);
            }
        }
    }

    @Override
    public void removeCommitWebHook(BitbucketWebHook hook) throws IOException {
        switch (this.webhookImplementation) {
            case PLUGIN: {
                this.deleteRequest(UriTemplate.fromTemplate((String)(this.baseURL + WEBHOOK_REPOSITORY_CONFIG_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)hook.getUuid()).expand());
                break;
            }
            case NATIVE: {
                this.deleteRequest(UriTemplate.fromTemplate((String)(this.baseURL + API_WEBHOOKS_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("id", (Object)hook.getUuid()).expand());
                break;
            }
            default: {
                this.logger.log(Level.WARNING, "Cannot remove {0} webhook.", (Object)this.webhookImplementation);
            }
        }
    }

    @Override
    @NonNull
    public List<? extends BitbucketWebHook> getWebHooks() throws IOException {
        switch (this.webhookImplementation) {
            case PLUGIN: {
                String url = UriTemplate.fromTemplate((String)(this.baseURL + WEBHOOK_REPOSITORY_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).expand();
                return this.getRequestAs(url, BitbucketServerWebhooks.class);
            }
            case NATIVE: {
                UriTemplate uriTemplate = UriTemplate.fromTemplate((String)(this.baseURL + API_WEBHOOKS_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName);
                return this.getPagedRequest(uriTemplate, NativeBitbucketServerWebhook.class);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public BitbucketTeam getTeam() throws IOException {
        if (this.userCentric) {
            return null;
        }
        String url = UriTemplate.fromTemplate((String)(this.baseURL + API_PROJECT_PATH)).set("owner", (Object)this.getOwner()).expand();
        try {
            return this.getRequestAs(url, BitbucketServerProject.class);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    @Deprecated(since="935.0.0", forRemoval=true)
    public AvatarImage getTeamAvatar() throws IOException {
        if (this.userCentric) {
            return AvatarImage.EMPTY;
        }
        String url = UriTemplate.fromTemplate((String)(this.baseURL + AVATAR_PATH)).set("owner", (Object)this.getOwner()).expand();
        return this.getAvatar(url);
    }

    @Override
    public AvatarImage getAvatar(@NonNull String url) throws IOException {
        try {
            BufferedImage response = this.getImageRequest(url);
            return new AvatarImage(response, System.currentTimeMillis());
        }
        catch (FileNotFoundException e) {
            return AvatarImage.EMPTY;
        }
    }

    @NonNull
    public List<BitbucketServerRepository> getRepositories(@CheckForNull UserRoleInRepository role) throws IOException {
        UriTemplate template = UriTemplate.fromTemplate((String)(this.baseURL + API_REPOSITORIES_PATH)).set("owner", (Object)this.getUserCentricOwner());
        List<BitbucketServerRepository> repositories = new ArrayList<BitbucketServerRepository>();
        try {
            repositories = this.getPagedRequest(template, BitbucketServerRepository.class);
            repositories.removeIf(BitbucketServerRepository::isArchived);
            repositories.sort(Comparator.comparing(BitbucketServerRepository::getRepositoryName));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return repositories;
    }

    @NonNull
    public List<BitbucketServerRepository> getRepositories() throws IOException {
        return this.getRepositories(null);
    }

    @Override
    public boolean isPrivate() throws IOException {
        return this.getRepository().isPrivate();
    }

    private <V> V getRequestAs(String url, Class<V> resultType) throws IOException {
        String response = this.getRequest(url);
        try {
            return JsonParser.toJava(response, resultType);
        }
        catch (JacksonException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    private <V> List<V> getPagedRequest(UriTemplate template, final Class<V> resultType) throws IOException {
        final ParameterizedType parameterizedType = new ParameterizedType(){

            @Override
            public Type getRawType() {
                return PagedApiResponse.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{resultType};
            }
        };
        String url = null;
        try {
            PagedApiResponse page;
            TypeReference type = new TypeReference<PagedApiResponse<V>>(){

                public Type getType() {
                    return parameterizedType;
                }
            };
            ArrayList resources = new ArrayList();
            Integer pageNumber = 0;
            Integer limit = DEFAULT_PAGE_LIMIT;
            do {
                url = template.set("start", (Object)pageNumber).set("limit", (Object)limit).expand();
                String response = this.getRequest(url);
                page = (PagedApiResponse)JsonParser.toJava(response, type);
                resources.addAll(page.getValues());
                limit = page.getLimit();
                pageNumber = page.getNextPageStart();
            } while (!page.isLastPage());
            return resources;
        }
        catch (JacksonException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    private <V> V getResource(UriTemplate template, Class<? extends PagedApiResponse<V>> clazz, Predicate<V> filter) throws IOException {
        String url = null;
        try {
            PagedApiResponse<V> page;
            Integer pageNumber = 0;
            Integer limit = DEFAULT_PAGE_LIMIT;
            do {
                url = template.set("start", (Object)pageNumber).set("limit", (Object)limit).expand();
                String response = this.getRequest(url);
                page = JsonParser.toJava(response, clazz);
                for (V item : page.getValues()) {
                    if (!filter.test(item)) continue;
                    return item;
                }
                limit = page.getLimit();
                pageNumber = page.getNextPageStart();
            } while (!page.isLastPage());
            return null;
        }
        catch (JacksonException e) {
            throw new IOException("I/O error when parsing response from URL: " + url, e);
        }
    }

    private BufferedImage getImageRequest(String path) throws IOException {
        try (InputStream inputStream = this.getRequestAsInputStream(path);){
            int length = 16384;
            BufferedInputStream bis = new BufferedInputStream(inputStream, length);
            BufferedImage bufferedImage = ImageIO.read(bis);
            return bufferedImage;
        }
    }

    @Override
    protected HttpClientConnectionManager getConnectionManager() {
        return connectionManager;
    }

    @Override
    @NonNull
    protected CloseableHttpClient getClient() {
        return this.client;
    }

    @Override
    @NonNull
    protected HttpHost getHost() {
        return BitbucketApiUtils.toHttpHost(this.baseURL);
    }

    @Override
    public Iterable<SCMFile> getDirectoryContent(BitbucketSCMFile directory) throws IOException {
        ArrayList<SCMFile> files = new ArrayList<SCMFile>();
        int start = 0;
        String branchOrHash = directory.getHash().contains("+") ? directory.getRef() : directory.getHash();
        UriTemplate template = UriTemplate.fromTemplate((String)(this.baseURL + "/rest/api/1.0/projects/{owner}/repos/{repo}/browse{/path*}{?at}{&start,limit}")).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("path", (Object)directory.getPath().split(Operator.PATH.getSeparator())).set("at", (Object)branchOrHash).set("start", (Object)start).set("limit", (Object)500);
        String url = template.expand();
        String response = this.getRequest(url);
        Map content = (Map)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map page = (Map)content.get("children");
        List values = (List)page.get("values");
        this.collectFileAndDirectories(directory, values, files);
        while (!((Boolean)page.get("isLastPage")).booleanValue()) {
            url = template.set("start", (Object)(start += ((Integer)content.get("size")).intValue())).expand();
            response = this.getRequest(url);
            content = (Map)JsonParser.mapper.readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
            page = (Map)content.get("children");
        }
        return files;
    }

    private void collectFileAndDirectories(BitbucketSCMFile parent, List<Map> values, List<SCMFile> files) {
        for (Map file : values) {
            String type = (String)file.get("type");
            List components = (List)((Map)file.get("path")).get("components");
            SCMFile.Type fileType = null;
            if (type.equals("FILE")) {
                fileType = SCMFile.Type.REGULAR_FILE;
            } else if (type.equals("DIRECTORY")) {
                fileType = SCMFile.Type.DIRECTORY;
            }
            if (components.isEmpty() || fileType == null) continue;
            files.add(new BitbucketSCMFile(parent, (String)components.get(0), fileType, null));
        }
    }

    @Override
    public InputStream getFileContent(BitbucketSCMFile file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        String branchOrHash = file.getHash().contains("+") ? file.getRef() : file.getHash();
        UriTemplate template = UriTemplate.fromTemplate((String)(this.baseURL + "/rest/api/1.0/projects/{owner}/repos/{repo}/browse{/path*}{?at}{&start,limit}")).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("path", (Object)file.getPath().split(Operator.PATH.getSeparator())).set("at", (Object)branchOrHash).set("start", (Object)start).set("limit", (Object)500);
        String url = template.expand();
        String response = this.getRequest(url);
        Map<String, Object> content = this.collectLines(response, lines);
        while (!((Boolean)content.get("isLastPage")).booleanValue()) {
            url = template.set("start", (Object)(start += ((Integer)content.get("size")).intValue())).expand();
            response = this.getRequest(url);
            content = this.collectLines(response, lines);
        }
        return IOUtils.toInputStream((String)StringUtils.join(lines, (char)'\n'), (Charset)StandardCharsets.UTF_8);
    }

    private Map<String, Object> collectLines(String response, List<String> lines) throws IOException {
        Map<String, Object> content = JsonParser.toJava(response, new TypeReference<Map<String, Object>>(){});
        List lineMap = (List)content.get("lines");
        for (Map line : lineMap) {
            String text = (String)line.get("text");
            if (text == null) continue;
            lines.add(text);
        }
        return content;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    @NonNull
    public SCMFile getFile(@NonNull BitbucketSCMFile file) throws IOException {
        String branchOrHash = file.getHash().contains("+") ? file.getRef() : file.getHash();
        String url = UriTemplate.fromTemplate((String)(this.baseURL + "/rest/api/1.0/projects/{owner}/repos/{repo}/browse{/path*}{?at}{&type,blame}")).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("path", (Object)file.getPath().split(Operator.PATH.getSeparator())).set("at", (Object)branchOrHash).set("type", (Object)true).set("blame", (Object)false).expand();
        SCMFile.Type type = SCMFile.Type.OTHER;
        try {
            String response = this.getRequest(url);
            JsonNode typeNode = JsonParser.mapper.readTree(response).path("type");
            if (!typeNode.isMissingNode() && !typeNode.isNull()) {
                String responseType = typeNode.asText();
                if ("FILE".equals(responseType)) {
                    type = SCMFile.Type.REGULAR_FILE;
                } else if ("DIRECTORY".equals(responseType)) {
                    type = SCMFile.Type.DIRECTORY;
                } else if ("SUBMODULE".equals(responseType)) {
                    type = SCMFile.Type.OTHER;
                }
            }
        }
        catch (FileNotFoundException e) {
            type = SCMFile.Type.NONEXISTENT;
        }
        return new BitbucketSCMFile((BitbucketSCMFile)file.parent(), file.getName(), type, file.getHash());
    }

    @NonNull
    public List<BitbucketServerCommit> getCommits(String fromCommit, String toCommit) throws IOException {
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)(this.baseURL + API_COMMITS_PATH)).set("owner", (Object)this.getUserCentricOwner()).set("repo", (Object)this.repositoryName).set("since", (Object)fromCommit).set("until", (Object)toCommit);
        return this.getPagedRequest(uriTemplate, BitbucketServerCommit.class);
    }

    private class CommitClosure
    implements Callable<BitbucketCommit> {
        private final String hash;

        public CommitClosure(String hash) {
            this.hash = hash;
        }

        @Override
        public BitbucketCommit call() throws Exception {
            return BitbucketServerAPIClient.this.resolveCommit(this.hash);
        }
    }
}

