/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.views;

import com.cloudbees.hudson.plugins.folder.views.AbstractFolderViewHolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AllView;
import hudson.model.View;
import hudson.views.ViewsTabBar;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.kohsuke.stapler.DataBoundConstructor;

public class DefaultFolderViewHolder
extends AbstractFolderViewHolder {
    @NonNull
    private CopyOnWriteArrayList<View> views;
    @CheckForNull
    private String primaryView;
    @NonNull
    private ViewsTabBar tabBar;

    @DataBoundConstructor
    public DefaultFolderViewHolder(@NonNull Collection<? extends View> views, @CheckForNull String primaryView, @NonNull ViewsTabBar tabBar) {
        if (views.isEmpty()) {
            throw new IllegalArgumentException("Initial views cannot be empty");
        }
        this.views = new CopyOnWriteArrayList<View>(views);
        this.primaryView = primaryView;
        this.tabBar = tabBar;
    }

    @Override
    public List<View> getViews() {
        return this.views;
    }

    @Override
    public void setViews(List<? extends View> views) {
        if (views.isEmpty()) {
            throw new IllegalArgumentException("Views cannot be empty");
        }
        this.views = new CopyOnWriteArrayList<View>(views);
    }

    @Override
    public String getPrimaryView() {
        return this.primaryView;
    }

    @Override
    public void setPrimaryView(String primaryView) {
        this.primaryView = primaryView;
    }

    @Override
    public ViewsTabBar getTabBar() {
        return this.tabBar;
    }

    @Override
    public void setTabBar(ViewsTabBar tabBar) {
        this.tabBar = tabBar;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.primaryView != null) {
            this.primaryView = AllView.migrateLegacyPrimaryAllViewLocalizedName(this.views, (String)this.primaryView);
        }
        return this;
    }
}

