/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.SubTask;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
public class ItemDeletion
extends Queue.QueueDecisionHandler {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private final Set<Item> registrations = new HashSet<Item>();

    @GuardedBy(value="lock")
    private boolean _contains(@Nonnull Item item) {
        if (this.registrations.isEmpty()) {
            return false;
        }
        while (item != null) {
            if (this.registrations.contains(item)) {
                return true;
            }
            if (!(item.getParent() instanceof Item)) break;
            item = (Item)item.getParent();
        }
        return false;
    }

    public static boolean contains(@Nonnull Item item) {
        ItemDeletion instance = ItemDeletion.instance();
        if (instance == null) {
            return false;
        }
        instance.lock.readLock().lock();
        try {
            boolean bl = instance._contains(item);
            return bl;
        }
        finally {
            instance.lock.readLock().unlock();
        }
    }

    public static boolean isRegistered(@Nonnull Item item) {
        ItemDeletion instance = ItemDeletion.instance();
        if (instance == null) {
            return false;
        }
        instance.lock.readLock().lock();
        try {
            boolean bl = instance.registrations.contains(item);
            return bl;
        }
        finally {
            instance.lock.readLock().unlock();
        }
    }

    public static boolean register(@Nonnull Item item) {
        ItemDeletion instance = ItemDeletion.instance();
        if (instance == null) {
            return false;
        }
        instance.lock.writeLock().lock();
        try {
            boolean bl = instance.registrations.add(item);
            return bl;
        }
        finally {
            instance.lock.writeLock().unlock();
        }
    }

    public static void deregister(@Nonnull Item item) {
        ItemDeletion instance = ItemDeletion.instance();
        if (instance != null) {
            instance.lock.writeLock().lock();
            try {
                instance.registrations.remove(item);
            }
            finally {
                instance.lock.writeLock().unlock();
            }
        }
    }

    @CheckForNull
    private static ItemDeletion instance() {
        return (ItemDeletion)((Object)ExtensionList.lookup(Queue.QueueDecisionHandler.class).get(ItemDeletion.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldSchedule(Queue.Task p, List<Action> actions) {
        Item item = ItemDeletion.getItemOf((SubTask)p);
        if (item != null) {
            this.lock.readLock().lock();
            try {
                boolean bl = !this._contains(item);
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return true;
    }

    @CheckForNull
    public static Item getItemOf(@Nonnull SubTask t) {
        Queue.Task o;
        Queue.Task p = t.getOwnerTask();
        while (!(p instanceof Item) && (o = p.getOwnerTask()) != p) {
            p = o;
        }
        return p instanceof Item ? (Item)p : null;
    }
}

