// CHECKSTYLE:OFF

package org.jenkinsci.plugins.configfiles.buildwrapper;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code display_name}: {@code Provide Configuration files}.
     * 
     * @return
     *     {@code Provide Configuration files}
     */
    public static String display_name() {
        return holder.format("display_name");
    }

    /**
     * Key {@code display_name}: {@code Provide Configuration files}.
     * 
     * @return
     *     {@code Provide Configuration files}
     */
    public static Localizable _display_name() {
        return new Localizable(holder, "display_name");
    }

    /**
     * Key {@code console_output}: {@code copy managed file [{0}] to {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code copy managed file [{0}] to {1}}
     */
    public static String console_output(Object arg0, Object arg1) {
        return holder.format("console_output", arg0, arg1);
    }

    /**
     * Key {@code console_output}: {@code copy managed file [{0}] to {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code copy managed file [{0}] to {1}}
     */
    public static Localizable _console_output(Object arg0, Object arg1) {
        return new Localizable(holder, "console_output", arg0, arg1);
    }

}
