/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.job;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.security.Permission;
import hudson.slaves.WorkspaceList;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.mvn.GlobalSettingsProvider;
import jenkins.mvn.GlobalSettingsProviderDescriptor;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.common.CleanTempFilesAction;
import org.jenkinsci.plugins.configfiles.maven.GlobalMavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.MavenSettingsConfig;
import org.jenkinsci.plugins.configfiles.maven.job.SimpleEnvironment;
import org.jenkinsci.plugins.configfiles.maven.security.CredentialsHelper;
import org.jenkinsci.plugins.configfiles.maven.security.ServerCredentialMapping;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class MvnGlobalSettingsProvider
extends GlobalSettingsProvider {
    private static final Logger LOGGER = Logger.getLogger(MvnGlobalSettingsProvider.class.getName());
    private String settingsConfigId;

    @Deprecated
    public MvnGlobalSettingsProvider() {
    }

    @DataBoundConstructor
    public MvnGlobalSettingsProvider(String settingsConfigId) {
        this.settingsConfigId = settingsConfigId;
    }

    public String getSettingsConfigId() {
        return this.settingsConfigId;
    }

    public void setSettingsConfigId(String settingsConfigId) {
        this.settingsConfigId = settingsConfigId;
    }

    @CheckForNull
    private GlobalMavenSettingsConfig getGlobalMavenSettingsConfig(AbstractBuild<?, ?> build, TaskListener listener) {
        if (this.settingsConfigId != null && !this.settingsConfigId.isBlank()) {
            Object c = ConfigFiles.getByIdOrNull(build.getRootBuild(), this.settingsConfigId);
            if (c == null) {
                String msg = "your Apache Maven build is setup to use a global config with id " + this.settingsConfigId + " but can not find the config";
                listener.getLogger().println("ERROR: " + msg);
                throw new IllegalStateException(msg);
            }
            if (c instanceof GlobalMavenSettingsConfig) {
                return (GlobalMavenSettingsConfig)c;
            }
            return new GlobalMavenSettingsConfig(((Config)c).id, ((Config)c).name, ((Config)c).comment, ((Config)c).content, MavenSettingsConfig.isReplaceAllDefault, null);
        }
        return null;
    }

    public FilePath supplySettings(AbstractBuild<?, ?> build, TaskListener listener) {
        GlobalMavenSettingsConfig config = this.getGlobalMavenSettingsConfig(build, listener);
        if (config != null) {
            listener.getLogger().println("using global settings config with name " + config.name);
            listener.getLogger().println("Replacing all maven server entries not found in credentials list is " + config.getIsReplaceAll());
            if (config.content != null && !config.content.isBlank()) {
                try {
                    FilePath workspace = build.getWorkspace();
                    if (workspace != null) {
                        FilePath workDir = WorkspaceList.tempDir((FilePath)workspace);
                        String fileContent = config.content;
                        Map<String, StandardUsernameCredentials> resolvedCredentials = CredentialsHelper.resolveCredentials(build, config.getServerCredentialMappings(), listener);
                        Boolean isReplaceAll = config.getIsReplaceAll();
                        if (resolvedCredentials != null && !resolvedCredentials.isEmpty()) {
                            ArrayList<String> tempFiles = new ArrayList<String>();
                            fileContent = CredentialsHelper.fillAuthentication(fileContent, isReplaceAll, resolvedCredentials, workDir, tempFiles);
                            for (String tempFile : tempFiles) {
                                build.addAction((Action)new CleanTempFilesAction(tempFile));
                            }
                        }
                        FilePath configurationFile = workspace.createTextTempFile("global-settings", ".xml", fileContent, false);
                        LOGGER.log(Level.FINE, "Create {0}", new Object[]{configurationFile});
                        build.getEnvironments().add((Object)new SimpleEnvironment("MVN_GLOBALSETTINGS", configurationFile.getRemote()));
                        build.addAction((Action)new CleanTempFilesAction(configurationFile.getRemote()));
                        return configurationFile;
                    }
                    listener.getLogger().println("ERROR: can't supply maven settings, workspace is null / agent seems not connected...");
                }
                catch (Exception e) {
                    throw new IllegalStateException("the global settings.xml could not be supplied for the current build: " + e.getMessage());
                }
            }
        }
        return null;
    }

    @NonNull
    public List<String> getSensitiveContentForMasking(AbstractBuild<?, ?> build) {
        GlobalMavenSettingsConfig config = this.getGlobalMavenSettingsConfig(build, TaskListener.NULL);
        if (config != null) {
            List<ServerCredentialMapping> serverCredentialMappings = config.getServerCredentialMappings();
            List<String> secretsForMasking = CredentialsHelper.secretsForMasking(build, serverCredentialMappings);
            return secretsForMasking;
        }
        return Collections.emptyList();
    }

    @Extension(ordinal=10.0)
    public static class DescriptorImpl
    extends GlobalSettingsProviderDescriptor {
        public String getDisplayName() {
            return "provided global settings.xml";
        }

        public ListBoxModel doFillSettingsConfigIdItems(@AncestorInPath ItemGroup context, @AncestorInPath Item project, @QueryParameter String settingsConfigId) {
            Permission permToCheck = project == null ? Jenkins.MANAGE : Item.EXTENDED_READ;
            Jenkins contextToCheck = project == null ? Jenkins.get() : project;
            ListBoxModel items = new ListBoxModel();
            items.add("please select", "");
            if (!contextToCheck.hasPermission(permToCheck)) {
                items.add((Object)new ListBoxModel.Option("current", settingsConfigId, true));
                return items;
            }
            for (Config config : ConfigFiles.getConfigsInContext(context, GlobalMavenSettingsConfig.GlobalMavenSettingsConfigProvider.class)) {
                items.add((Object)new ListBoxModel.Option(config.name, config.id, config.id.equals(settingsConfigId)));
            }
            return items;
        }
    }
}

