/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import hudson.Extension;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.impl.CredentialNotFoundException;
import org.jenkinsci.plugins.credentialsbinding.impl.Messages;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatterns;
import org.kohsuke.stapler.DataBoundConstructor;

public class SecretBuildWrapper
extends BuildWrapper {
    private List<? extends MultiBinding<?>> bindings;
    private static final Map<AbstractBuild<?, ?>, Collection<String>> secretsForBuild = new WeakHashMap();

    @CheckForNull
    public static Pattern getPatternForBuild(@Nonnull AbstractBuild<?, ?> build) {
        if (secretsForBuild.containsKey(build)) {
            return SecretPatterns.getAggregateSecretPattern(secretsForBuild.get(build));
        }
        return null;
    }

    @DataBoundConstructor
    public SecretBuildWrapper(List<? extends MultiBinding<?>> bindings) {
        this.bindings = bindings == null ? Collections.emptyList() : bindings;
    }

    public List<? extends MultiBinding<?>> getBindings() {
        return this.bindings;
    }

    public OutputStream decorateLogger(AbstractBuild build, OutputStream logger) throws IOException, InterruptedException, Run.RunnerAbortedException {
        return new Filter(build.getCharset().name()).decorateLogger(build, logger);
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, final Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        final ArrayList<MultiBinding.MultiEnvironment> m = new ArrayList<MultiBinding.MultiEnvironment>();
        HashSet<String> secrets = new HashSet<String>();
        for (MultiBinding<?> binding : this.bindings) {
            MultiBinding.MultiEnvironment e = binding.bind((Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
            m.add(e);
            secrets.addAll(e.getSecretValues().values());
        }
        if (!secrets.isEmpty()) {
            secretsForBuild.put(build, secrets);
        }
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                for (MultiBinding.MultiEnvironment e : m) {
                    for (Map.Entry<String, String> pair : e.getSecretValues().entrySet()) {
                        env.put(pair.getKey(), pair.getValue().replace("$", "$$$$"));
                    }
                    for (Map.Entry<String, String> pair : e.getPublicValues().entrySet()) {
                        env.put(pair.getKey(), pair.getValue().replace("$", "$$$$"));
                    }
                }
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                for (MultiBinding.MultiEnvironment e : m) {
                    e.getUnbinder().unbind((Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
                }
                return true;
            }
        };
    }

    public void makeSensitiveBuildVariables(AbstractBuild build, Set<String> sensitiveVariables) {
        for (MultiBinding<?> binding : this.bindings) {
            try {
                sensitiveVariables.addAll(binding.variables((Run<?, ?>)build));
            }
            catch (CredentialNotFoundException credentialNotFoundException) {}
        }
    }

    protected Object readResolve() {
        if (this.bindings == null) {
            this.bindings = Collections.emptyList();
        }
        return this;
    }

    @Extension(ordinal=100.0)
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.SecretBuildWrapper_use_secret_text_s_or_file_s_();
        }
    }

    private static final class Filter
    extends ConsoleLogFilter {
        private final String charsetName;

        Filter(String charsetName) {
            this.charsetName = charsetName;
        }

        public OutputStream decorateLogger(final AbstractBuild build, OutputStream logger) throws IOException, InterruptedException {
            return new SecretPatterns.MaskingOutputStream(logger, () -> SecretBuildWrapper.getPatternForBuild(build), this.charsetName){

                public void close() throws IOException {
                    super.close();
                    secretsForBuild.remove(build);
                }
            };
        }
    }
}

