/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.domains;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.DomainSpecificationDescriptor;
import com.cloudbees.plugins.credentials.domains.Messages;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import java.util.LinkedHashSet;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

public class SchemeSpecification
extends DomainSpecification {
    @NonNull
    private final Set<String> schemes = new LinkedHashSet<String>();

    @DataBoundConstructor
    public SchemeSpecification(@CheckForNull String schemes) {
        schemes = Util.fixEmptyAndTrim((String)schemes);
        if (schemes != null) {
            for (String scheme : schemes.split("[,\\n ]")) {
                if ((scheme = Util.fixEmptyAndTrim((String)scheme)) == null) continue;
                this.schemes.add(SchemeSpecification.toWellFormedScheme(scheme));
            }
        }
    }

    @NonNull
    private static String toWellFormedScheme(@NonNull String scheme) {
        int index = (scheme = scheme.toLowerCase()).indexOf(58);
        if (index != -1) {
            scheme = scheme.substring(0, index);
        }
        return scheme;
    }

    @CheckForNull
    public String getSchemes() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String scheme : this.schemes) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(scheme);
        }
        return Util.fixEmptyAndTrim((String)buf.toString());
    }

    @Override
    @NonNull
    public DomainSpecification.Result test(@NonNull DomainRequirement requirement) {
        if (requirement instanceof SchemeRequirement) {
            String scheme = SchemeSpecification.toWellFormedScheme(((SchemeRequirement)requirement).getScheme());
            if (!this.schemes.isEmpty() && this.schemes.contains(scheme)) {
                return DomainSpecification.Result.POSITIVE;
            }
            return DomainSpecification.Result.NEGATIVE;
        }
        return DomainSpecification.Result.UNKNOWN;
    }

    @Extension
    public static class DescriptorImpl
    extends DomainSpecificationDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.SchemeSpecification_DisplayName();
        }
    }
}

