/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.impl;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SecretBytes;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.RelativePath;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.crypto.interfaces.DHPrivateKey;
import javax.security.auth.DestroyFailedException;
import jenkins.bouncycastle.api.PEMEncodable;
import jenkins.model.Jenkins;
import jenkins.security.FIPS140;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

public class CertificateCredentialsImpl
extends BaseStandardCredentials
implements StandardCertificateCredentials {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CertificateCredentialsImpl.class.getName());
    private final KeyStoreSource keyStoreSource;
    private final Secret password;
    @GuardedBy(value="this")
    @CheckForNull
    private transient KeyStore keyStore;
    @GuardedBy(value="this")
    private transient long keyStoreLastModified;

    @DataBoundConstructor
    public CertificateCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull String password, @NonNull KeyStoreSource keyStoreSource) {
        super(scope, id, description);
        Objects.requireNonNull(keyStoreSource);
        if (FIPS140.useCompliantAlgorithms() && StringUtils.length((String)password) < 14) {
            throw new IllegalArgumentException(Messages.CertificateCredentialsImpl_ShortPasswordFIPS());
        }
        this.password = Secret.fromString((String)password);
        this.keyStoreSource = keyStoreSource;
        try {
            keyStoreSource.toKeyStore(CertificateCredentialsImpl.toCharArray(this.password));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("KeyStore is not valid.", e);
        }
    }

    private static char[] toCharArray(@NonNull Secret password) {
        return password.getPlainText().toCharArray();
    }

    @Override
    @NonNull
    public synchronized KeyStore getKeyStore() {
        long lastModified = this.keyStoreSource.getKeyStoreLastModified();
        if (this.keyStore == null || this.keyStoreLastModified < lastModified) {
            KeyStore keyStore;
            try {
                keyStore = this.keyStoreSource.toKeyStore(CertificateCredentialsImpl.toCharArray(this.password));
            }
            catch (IOException | GeneralSecurityException e) {
                LogRecord lr = new LogRecord(Level.WARNING, "Credentials ID {0}: Could not load keystore from {1}");
                lr.setParameters(new Object[]{this.getId(), this.keyStoreSource});
                lr.setThrown(e);
                LOGGER.log(lr);
                try {
                    keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                }
                catch (KeyStoreException e2) {
                    throw new IllegalStateException("JVM can not create a KeyStore of the JVM Default Type (" + KeyStore.getDefaultType() + ")", e2);
                }
            }
            this.keyStore = keyStore;
            this.keyStoreLastModified = lastModified;
        }
        return this.keyStore;
    }

    @Override
    @NonNull
    public Secret getPassword() {
        return this.password;
    }

    public boolean isPasswordEmpty() {
        return StringUtils.isEmpty((String)this.password.getPlainText());
    }

    public KeyStoreSource getKeyStoreSource() {
        return this.keyStoreSource;
    }

    static {
        Items.XSTREAM2.addCriticalField(CertificateCredentialsImpl.class, "keyStoreSource");
    }

    public static abstract class KeyStoreSource
    extends AbstractDescribableImpl<KeyStoreSource> {
        @Deprecated(forRemoval=true)
        @NonNull
        public byte[] getKeyStoreBytes() {
            throw new IllegalStateException("Callers should use toKeyStore");
        }

        public abstract long getKeyStoreLastModified();

        @NonNull
        public abstract KeyStore toKeyStore(@Nullable char[] var1) throws GeneralSecurityException, IOException;

        @Deprecated
        public boolean isSnapshotSource() {
            return false;
        }
    }

    public static class PEMEntryKeyStoreSource
    extends KeyStoreSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Secret certChain;
        private final Secret privateKey;

        @DataBoundConstructor
        public PEMEntryKeyStoreSource(String certChain, String privateKey) {
            this.certChain = Secret.fromString((String)certChain);
            this.privateKey = Secret.fromString((String)privateKey);
        }

        @Restricted(value={NoExternalUse.class})
        public Secret getCertChain() {
            return this.certChain;
        }

        @Restricted(value={NoExternalUse.class})
        public Secret getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public long getKeyStoreLastModified() {
            return 0L;
        }

        @Override
        public boolean isSnapshotSource() {
            return true;
        }

        @Override
        public KeyStore toKeyStore(char[] password) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, KeyStoreException, UnrecoverableKeyException, IOException {
            return PEMEntryKeyStoreSource.toKeyStore(this.certChain.getPlainText(), this.privateKey.getPlainText(), password);
        }

        protected static KeyStore toKeyStore(String pemEncodedCerts, String pemEncodedKey, char[] password) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, KeyStoreException, UnrecoverableKeyException, IOException {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            List pemEncodeableCerts = PEMEncodable.decodeAll((String)pemEncodedCerts, (char[])password);
            List<Certificate> certs = pemEncodeableCerts.stream().map(PEMEncodable::toCertificate).filter(Objects::nonNull).collect(Collectors.toList());
            List pemEncodeableKeys = PEMEncodable.decodeAll((String)pemEncodedKey, (char[])password);
            if (pemEncodeableKeys.size() != 1) {
                throw new IOException("expected one key but got " + pemEncodeableKeys.size());
            }
            PrivateKey privateKey = ((PEMEncodable)pemEncodeableKeys.get(0)).toPrivateKey();
            keyStore.setKeyEntry("keychain", privateKey, password, certs.toArray(new Certificate[0]));
            return keyStore;
        }

        public String toString() {
            return "PEMEntryKeyStoreSource{pemCertChain=******,pemKey=******}";
        }

        @Extension
        public static class DescriptorImpl
        extends KeyStoreSourceDescriptor {
            @NonNull
            public String getDisplayName() {
                return Messages.CertificateCredentialsImpl_PEMEntryKeyStoreSourceDisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            @POST
            public FormValidation doCheckCertChain(@QueryParameter String value) {
                String pemCerts = Secret.fromString((String)value).getPlainText();
                try {
                    List pemEncodables = PEMEncodable.decodeAll((String)pemCerts, null);
                    long count = pemEncodables.stream().map(PEMEncodable::toCertificate).filter(Objects::nonNull).count();
                    if (count < 1L) {
                        if (Util.fixEmpty((String)value) == null) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)Messages.CertificateCredentialsImpl_PEMNoCertificates());
                    }
                    if ((long)pemEncodables.size() != count) {
                        return FormValidation.error((String)Messages.CertificateCredentialsImpl_PEMNoCertificates());
                    }
                    Certificate cert = ((PEMEncodable)pemEncodables.get(0)).toCertificate();
                    if (cert instanceof X509Certificate) {
                        X509Certificate x509 = (X509Certificate)cert;
                        return FormValidation.ok((String)x509.getSubjectDN().getName());
                    }
                    return FormValidation.ok();
                }
                catch (IOException | UnrecoverableKeyException e) {
                    String message = e.getMessage();
                    if (message != null) {
                        return FormValidation.error((Throwable)e, (String)Messages.CertificateCredentialsImpl_PEMCertificateParsingError(message));
                    }
                    return FormValidation.error((Throwable)e, (String)Messages.CertificateCredentialsImpl_PEMCertificateParsingError("unkown reason"));
                }
            }

            @Restricted(value={NoExternalUse.class})
            @POST
            public FormValidation doCheckPrivateKey(@QueryParameter String value, @RelativePath(value="..") @QueryParameter String password) {
                String key = Secret.fromString((String)value).getPlainText();
                try {
                    Object length;
                    Object format;
                    List pemEncodables = PEMEncodable.decodeAll((String)key, (char[])CertificateCredentialsImpl.toCharArray(Secret.fromString((String)password)));
                    long count = pemEncodables.stream().map(PEMEncodable::toPrivateKey).filter(Objects::nonNull).count();
                    if (count == 0L) {
                        if (Util.fixEmpty((String)value) == null) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)Messages.CertificateCredentialsImpl_PEMNoKeys());
                    }
                    if (count > 1L) {
                        return FormValidation.error((String)Messages.CertificateCredentialsImpl_PEMMultipleKeys());
                    }
                    if (pemEncodables.size() != 1) {
                        return FormValidation.error((String)Messages.CertificateCredentialsImpl_PEMNonKeys());
                    }
                    PrivateKey pk = ((PEMEncodable)pemEncodables.get(0)).toPrivateKey();
                    if (pk instanceof RSAPrivateKey) {
                        format = "RSA";
                        length = ((RSAKey)((Object)pk)).getModulus().bitLength() + " bit";
                    } else if (pk instanceof ECPrivateKey) {
                        format = "elliptic curve (EC)";
                        length = ((ECPrivateKey)pk).getParams().getOrder().bitLength() + " bit";
                    } else if (pk instanceof DSAPrivateKey) {
                        format = "DSA";
                        length = ((DSAPrivateKey)pk).getParams().getP().bitLength() + " bit";
                    } else if (pk instanceof DHPrivateKey) {
                        format = "Diffie-Hellman";
                        length = ((DHPrivateKey)pk).getParams().getP().bitLength() + " bit";
                    } else if (pk != null) {
                        format = "unknown format (" + String.valueOf(pk.getClass()) + ")";
                        length = "unknown strength";
                    } else {
                        return FormValidation.error((String)"there is a bug in the code, pk is null!");
                    }
                    try {
                        pk.destroy();
                    }
                    catch (DestroyFailedException destroyFailedException) {
                        // empty catch block
                    }
                    return FormValidation.ok((String)Messages.CertificateCredentialsImpl_PEMKeyInfo(length, format));
                }
                catch (IOException | UnrecoverableKeyException e) {
                    return FormValidation.error((Throwable)e, (String)Messages.CertificateCredentialsImpl_PEMKeyParseError(e.getLocalizedMessage()));
                }
            }
        }
    }

    public static class UploadedKeyStoreSource
    extends KeyStoreSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Deprecated
        @CheckForNull
        private transient Secret uploadedKeystore;
        @CheckForNull
        private final SecretBytes uploadedKeystoreBytes;

        @Deprecated
        public UploadedKeyStoreSource(String uploadedKeystore) {
            UploadedKeyStoreSource.ensureNotRunningInFIPSMode();
            this.uploadedKeystoreBytes = StringUtils.isBlank((String)uploadedKeystore) ? null : SecretBytes.fromBytes(DescriptorImpl.toByteArray(Secret.fromString((String)uploadedKeystore)));
        }

        @Deprecated
        public UploadedKeyStoreSource(@CheckForNull SecretBytes uploadedKeystore) {
            UploadedKeyStoreSource.ensureNotRunningInFIPSMode();
            this.uploadedKeystoreBytes = uploadedKeystore;
        }

        @DataBoundConstructor
        public UploadedKeyStoreSource(FileItem uploadedCertFile, @CheckForNull SecretBytes uploadedKeystore) {
            byte[] fileBytes;
            UploadedKeyStoreSource.ensureNotRunningInFIPSMode();
            if (uploadedCertFile != null && (fileBytes = uploadedCertFile.get()).length != 0) {
                uploadedKeystore = SecretBytes.fromBytes(fileBytes);
            }
            this.uploadedKeystoreBytes = uploadedKeystore;
        }

        private Object readResolve() throws ObjectStreamException {
            UploadedKeyStoreSource.ensureNotRunningInFIPSMode();
            if (this.uploadedKeystore != null && this.uploadedKeystoreBytes == null) {
                return new UploadedKeyStoreSource(SecretBytes.fromBytes(DescriptorImpl.toByteArray(this.uploadedKeystore)));
            }
            return this;
        }

        public SecretBytes getUploadedKeystore() {
            return this.uploadedKeystoreBytes;
        }

        @Override
        @NonNull
        public byte[] getKeyStoreBytes() {
            return SecretBytes.getPlainData(this.uploadedKeystoreBytes);
        }

        @Override
        public long getKeyStoreLastModified() {
            return 0L;
        }

        @Override
        public boolean isSnapshotSource() {
            return true;
        }

        @Override
        public KeyStore toKeyStore(char[] password) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, KeyStoreException, IOException {
            if (FIPS140.useCompliantAlgorithms()) {
                Class<?> self = this.getClass();
                String className = self.getName();
                String pluginName = Jenkins.get().getPluginManager().whichPlugin(self).getShortName();
                throw new IllegalStateException(className + " is not FIPS compliant and can not be used when Jenkins is in FIPS mode. An issue should be filed against the plugin " + pluginName + " to ensure it is adapted to be able to work in this mode");
            }
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new ByteArrayInputStream(this.getKeyStoreBytes()), password);
            return keyStore;
        }

        public String toString() {
            return "UploadedKeyStoreSource{uploadedKeystoreBytes=******}";
        }

        private static void ensureNotRunningInFIPSMode() {
            if (FIPS140.useCompliantAlgorithms()) {
                throw new IllegalStateException("UploadedKeyStoreSource is not compliant with FIPS-140 and can not be used when Jenkins is in FIPS mode. This is an error in the calling code and an issue should be filed against the plugin that is calling to adapt to become FIPS compliant.");
            }
        }

        public static class DescriptorImpl
        extends KeyStoreSourceDescriptor {
            public static final String DEFAULT_VALUE = UploadedKeyStoreSource.class.getName() + ".default-value";

            @Restricted(value={NoExternalUse.class})
            @Extension
            public static KeyStoreSourceDescriptor extension() {
                return FIPS140.useCompliantAlgorithms() ? null : new DescriptorImpl();
            }

            @NonNull
            public static byte[] toByteArray(@Nullable Secret secret) {
                byte[] decoded;
                if (secret != null && null != (decoded = Base64.getDecoder().decode(secret.getPlainText()))) {
                    return decoded;
                }
                return new byte[0];
            }

            @Deprecated
            @CheckForNull
            public static Secret toSecret(@Nullable byte[] contents) {
                return contents == null || contents.length == 0 ? null : Secret.fromString((String)Base64.getEncoder().encodeToString(contents));
            }

            @NonNull
            public String getDisplayName() {
                return Messages.CertificateCredentialsImpl_UploadedKeyStoreSourceDisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            @RequirePOST
            public FormValidation doCheckUploadedKeystore(@QueryParameter String value, @QueryParameter String certificateBase64, @QueryParameter String password) {
                if (StringUtils.isNotEmpty((String)certificateBase64)) {
                    byte[] uploadedCertFileBytes = Base64.getDecoder().decode(certificateBase64.getBytes(StandardCharsets.UTF_8));
                    return DescriptorImpl.validateCertificateKeystore(uploadedCertFileBytes, password);
                }
                if (StringUtils.isBlank((String)value)) {
                    return FormValidation.error((String)Messages.CertificateCredentialsImpl_NoCertificateUploaded());
                }
                if (DEFAULT_VALUE.equals(value)) {
                    return FormValidation.ok();
                }
                SecretBytes secretBytes = SecretBytes.fromString(value);
                byte[] keystoreBytes = secretBytes.getPlainData();
                if (keystoreBytes == null || keystoreBytes.length == 0) {
                    return FormValidation.error((String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                }
                return DescriptorImpl.validateCertificateKeystore(keystoreBytes, password);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NonNull
            protected static FormValidation validateCertificateKeystore(byte[] keystoreBytes, String password) {
                UploadedKeyStoreSource.ensureNotRunningInFIPSMode();
                if (keystoreBytes == null || keystoreBytes.length == 0) {
                    return FormValidation.warning((String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                }
                char[] passwordChars = CertificateCredentialsImpl.toCharArray(Secret.fromString((String)password));
                try {
                    KeyStore keyStore = KeyStore.getInstance("PKCS12");
                    keyStore.load(new ByteArrayInputStream(keystoreBytes), passwordChars);
                    FormValidation formValidation = DescriptorImpl.validateCertificateKeystore(keyStore, passwordChars);
                    return formValidation;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    FormValidation formValidation = FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeystoreFailed());
                    return formValidation;
                }
                finally {
                    Arrays.fill(passwordChars, ' ');
                }
            }
        }
    }

    public static abstract class KeyStoreSourceDescriptor
    extends Descriptor<KeyStoreSource> {
        protected static FormValidation validateCertificateKeystore(KeyStore keyStore, char[] passwordChars) throws KeyStoreException, NoSuchAlgorithmException {
            int size = keyStore.size();
            if (size == 0) {
                return FormValidation.warning((String)Messages.CertificateCredentialsImpl_EmptyKeystore());
            }
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(alias);
                if (keyStore.isCertificateEntry(alias)) {
                    keyStore.getCertificate(alias);
                    continue;
                }
                if (!keyStore.isKeyEntry(alias)) continue;
                if (passwordChars == null) {
                    return FormValidation.warning((String)Messages.CertificateCredentialsImpl_LoadKeyFailedQueryEmptyPassword(alias));
                }
                try {
                    keyStore.getKey(alias, passwordChars);
                }
                catch (UnrecoverableEntryException e) {
                    return FormValidation.warning((Throwable)e, (String)Messages.CertificateCredentialsImpl_LoadKeyFailed(alias));
                }
            }
            return FormValidation.ok((String)StringUtils.defaultIfEmpty((String)StandardCertificateCredentials.NameProvider.getSubjectDN(keyStore), (String)buf.toString()));
        }

        protected KeyStoreSourceDescriptor() {
        }

        protected KeyStoreSourceDescriptor(Class<? extends KeyStoreSource> clazz) {
            super(clazz);
        }
    }

    @Extension(ordinal=-1.0)
    @Symbol(value={"certificate"})
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.CertificateCredentialsImpl_DisplayName();
        }

        @Override
        public String getIconClassName() {
            return "icon-application-certificate";
        }

        @Restricted(value={NoExternalUse.class})
        @POST
        public FormValidation doCheckPassword(@QueryParameter String value) {
            Secret s = Secret.fromString((String)value);
            String pw = s.getPlainText();
            if (FIPS140.useCompliantAlgorithms() && pw.length() < 14) {
                return FormValidation.error((String)Messages.CertificateCredentialsImpl_ShortPasswordFIPS());
            }
            if (pw.isEmpty()) {
                return FormValidation.ok((String)Messages.CertificateCredentialsImpl_NoPassword());
            }
            if (pw.length() < 14) {
                return FormValidation.warning((String)Messages.CertificateCredentialsImpl_ShortPassword());
            }
            return FormValidation.ok();
        }
    }
}

