/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsProviderTypeRestrictionDescriptor;
import com.cloudbees.plugins.credentials.Messages;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class CredentialsProviderTypeRestriction
extends AbstractDescribableImpl<CredentialsProviderTypeRestriction>
implements Serializable,
ExtensionPoint {
    private static final long serialVersionUID = 1L;

    public abstract boolean filter(CredentialsProvider var1, CredentialsDescriptor var2);

    public CredentialsProviderTypeRestrictionDescriptor getDescriptor() {
        return (CredentialsProviderTypeRestrictionDescriptor)super.getDescriptor();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public static class Excludes
    extends CredentialsProviderTypeRestriction {
        private static final long serialVersionUID = 1L;
        private final String provider;
        private final String type;

        @DataBoundConstructor
        public Excludes(String provider, String type) {
            this.provider = provider;
            this.type = type;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Excludes excludes = (Excludes)o;
            if (!this.provider.equals(excludes.provider)) {
                return false;
            }
            return this.type.equals(excludes.type);
        }

        @Override
        public int hashCode() {
            int result = this.provider.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "Excludes{provider='" + this.provider + '\'' + ", type='" + this.type + '\'' + '}';
        }

        @Override
        public boolean filter(CredentialsProvider provider, CredentialsDescriptor type) {
            return !((Object)((Object)provider)).getClass().getName().equals(this.provider) || !((Object)((Object)type)).getClass().getName().equals(this.type);
        }

        @Extension
        public static class DescriptorImpl
        extends CredentialsProviderTypeRestrictionDescriptor {
            @Override
            public boolean filter(List<CredentialsProviderTypeRestriction> restrictions, CredentialsProvider provider, CredentialsDescriptor type) {
                return restrictions.stream().allMatch(r -> r.filter(provider, type));
            }

            public String getDisplayName() {
                return Messages.CredentialsProviderTypeRestriction_Excludes_DisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            public ListBoxModel doFillProviderItems() {
                return ExtensionList.lookup(CredentialsProvider.class).stream().map(p -> new ListBoxModel.Option(p.getDisplayName(), ((Object)p).getClass().getName())).collect(Collectors.toCollection(ListBoxModel::new));
            }

            @Restricted(value={NoExternalUse.class})
            public ListBoxModel doFillTypeItems() {
                return ExtensionList.lookup(CredentialsDescriptor.class).stream().map(d -> new ListBoxModel.Option(d.getDisplayName(), ((Object)d).getClass().getName())).collect(Collectors.toCollection(ListBoxModel::new));
            }
        }
    }

    public static class Includes
    extends CredentialsProviderTypeRestriction {
        private static final long serialVersionUID = 1L;
        private final String provider;
        private final String type;

        @DataBoundConstructor
        public Includes(String provider, String type) {
            this.provider = provider;
            this.type = type;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Includes includes = (Includes)o;
            if (!this.provider.equals(includes.provider)) {
                return false;
            }
            return this.type.equals(includes.type);
        }

        @Override
        public int hashCode() {
            int result = this.provider.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "Includes{provider='" + this.provider + '\'' + ", type='" + this.type + '\'' + '}';
        }

        @Override
        public boolean filter(CredentialsProvider provider, CredentialsDescriptor type) {
            return ((Object)((Object)provider)).getClass().getName().equals(this.provider) && ((Object)((Object)type)).getClass().getName().equals(this.type);
        }

        @Extension
        public static class DescriptorImpl
        extends CredentialsProviderTypeRestrictionDescriptor {
            @Override
            public boolean filter(List<CredentialsProviderTypeRestriction> restrictions, CredentialsProvider provider, CredentialsDescriptor type) {
                boolean haveProviderMatch = false;
                for (CredentialsProviderTypeRestriction r : restrictions) {
                    if (!haveProviderMatch && r instanceof Includes && provider.clazz.getName().equals(((Includes)r).getProvider())) {
                        haveProviderMatch = true;
                    }
                    if (!r.filter(provider, type)) continue;
                    return true;
                }
                return !haveProviderMatch;
            }

            public String getDisplayName() {
                return Messages.CredentialsProviderTypeRestriction_Includes_DisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            public ListBoxModel doFillProviderItems() {
                return ExtensionList.lookup(CredentialsProvider.class).stream().map(p -> new ListBoxModel.Option(p.getDisplayName(), ((Object)p).getClass().getName())).collect(Collectors.toCollection(ListBoxModel::new));
            }

            @Restricted(value={NoExternalUse.class})
            public ListBoxModel doFillTypeItems() {
                return ExtensionList.lookup(CredentialsDescriptor.class).stream().map(d -> new ListBoxModel.Option(d.getDisplayName(), ((Object)d).getClass().getName())).collect(Collectors.toCollection(ListBoxModel::new));
            }
        }
    }
}

