/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.builds;

import com.cloudbees.plugins.credentials.CredentialsParameterValue;
import com.cloudbees.plugins.credentials.builds.CredentialsParameterBinding;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.InvisibleAction;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class CredentialsParameterBinder
extends InvisibleAction {
    private final Map<String, CredentialsParameterBinding> boundCredentials = new ConcurrentHashMap<String, CredentialsParameterBinding>();

    @Nonnull
    public static CredentialsParameterBinder getOrCreate(@Nonnull Run<?, ?> run) {
        CredentialsParameterBinder resolver = (CredentialsParameterBinder)run.getAction(CredentialsParameterBinder.class);
        if (resolver == null) {
            resolver = new CredentialsParameterBinder();
            ParametersAction action = (ParametersAction)run.getAction(ParametersAction.class);
            if (action != null) {
                Cause.UserIdCause cause = (Cause.UserIdCause)run.getCause(Cause.UserIdCause.class);
                String userId = cause == null ? null : cause.getUserId();
                for (ParameterValue parameterValue : action) {
                    if (!(parameterValue instanceof CredentialsParameterValue)) continue;
                    resolver.bindCredentialsParameter(userId, (CredentialsParameterValue)parameterValue);
                }
            }
            run.addAction((Action)resolver);
        }
        return resolver;
    }

    public void bindCredentialsParameter(@CheckForNull String userId, @Nonnull CredentialsParameterValue parameterValue) {
        this.boundCredentials.put(parameterValue.getName(), CredentialsParameterBinding.fromParameter(userId, parameterValue));
    }

    public void unbindCredentialsParameter(@Nonnull String parameterName) {
        this.boundCredentials.remove(parameterName);
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public CredentialsParameterBinding forParameterName(@Nonnull String parameterName) {
        return this.boundCredentials.get(parameterName);
    }

    boolean isEmpty() {
        return this.boundCredentials.isEmpty();
    }
}

