/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.security.Permission;
import hudson.util.ListBoxModel;
import java.util.Objects;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.user.PreferredProviderUserProperty;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
@Symbol(value={"defaultDisplayUrlProvider"})
public class DefaultDisplayURLProviderGlobalConfiguration
extends GlobalConfiguration {
    @CheckForNull
    private String providerId;

    public DefaultDisplayURLProviderGlobalConfiguration() {
        this.load();
    }

    @CheckForNull
    public String getProviderId() {
        return this.providerId;
    }

    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return Jenkins.MANAGE;
    }

    @DataBoundSetter
    public void setProviderId(@CheckForNull String providerId) {
        providerId = Util.fixEmptyAndTrim((String)providerId);
        if (PreferredProviderUserProperty.ProviderOption.DEFAULT_OPTION.getId().equals(providerId)) {
            providerId = null;
        }
        this.providerId = providerId;
        this.save();
    }

    @CheckForNull
    public DisplayURLProvider getConfiguredProvider() {
        if (this.providerId == null) {
            return null;
        }
        return DisplayURLProvider.all().stream().filter(provider -> provider.getClass().getName().equals(this.providerId)).findFirst().orElse(null);
    }

    public static DefaultDisplayURLProviderGlobalConfiguration get() {
        return (DefaultDisplayURLProviderGlobalConfiguration)((Object)ExtensionList.lookupSingleton(DefaultDisplayURLProviderGlobalConfiguration.class));
    }

    public ListBoxModel doFillProviderIdItems() {
        ListBoxModel items = new ListBoxModel();
        for (PreferredProviderUserProperty.ProviderOption providerOption : PreferredProviderUserProperty.getAll()) {
            ListBoxModel.Option option = new ListBoxModel.Option(providerOption.getName(), providerOption.getId(), Objects.equals(providerOption.getId(), this.providerId));
            items.add((Object)option);
        }
        return items;
    }
}

