/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import hudson.util.VersionNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.docker.commons.fingerprint.ContainerRecord;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerFingerprints;
import org.jenkinsci.plugins.docker.commons.tools.DockerTool;
import org.jenkinsci.plugins.docker.workflow.ImageAction;
import org.jenkinsci.plugins.docker.workflow.client.DockerClient;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WithContainerStep
extends AbstractStepImpl {
    private static final Logger LOGGER = Logger.getLogger(WithContainerStep.class.getName());
    @Nonnull
    private final String image;
    private String args;
    private String toolName;

    @DataBoundConstructor
    public WithContainerStep(@Nonnull String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    @DataBoundSetter
    public void setArgs(String args) {
        this.args = Util.fixEmpty((String)args);
    }

    public String getArgs() {
        return this.args;
    }

    public String getToolName() {
        return this.toolName;
    }

    @DataBoundSetter
    public void setToolName(String toolName) {
        this.toolName = Util.fixEmpty((String)toolName);
    }

    private static void destroy(String container, Launcher launcher, Node node, EnvVars launcherEnv, String toolName) throws Exception {
        new DockerClient(launcher, node, toolName).stop(launcherEnv, container);
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "withDockerContainer";
        }

        public String getDisplayName() {
            return "Run build steps inside a Docker container";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;
        private final String container;
        private final String toolName;

        Callback(String container, String toolName) {
            this.container = container;
            this.toolName = toolName;
        }

        protected void finished(StepContext context) throws Exception {
            WithContainerStep.destroy(this.container, (Launcher)context.get(Launcher.class), (Node)context.get(Node.class), (EnvVars)context.get(EnvVars.class), this.toolName);
        }
    }

    private static class Decorator
    extends LauncherDecorator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String container;
        private final String[] envHost;
        private final String ws;
        @CheckForNull
        private final String toolName;

        Decorator(String container, EnvVars envHost, String ws, String toolName) {
            this.container = container;
            this.envHost = Util.mapToEnv((Map)envHost);
            this.ws = ws;
            this.toolName = toolName;
        }

        public Launcher decorate(final Launcher launcher, final Node node) {
            return new Launcher.DecoratedLauncher(launcher){

                public Proc launch(Launcher.ProcStarter starter) throws IOException {
                    String path;
                    FilePath cwd;
                    String executable;
                    try {
                        executable = this.getExecutable();
                    }
                    catch (InterruptedException x) {
                        throw new IOException(x);
                    }
                    ArrayList<String> prefix = new ArrayList<String>(Arrays.asList(executable, "exec", Decorator.this.container, "env"));
                    if (Decorator.this.ws != null && (cwd = starter.pwd()) != null && !(path = cwd.getRemote()).equals(Decorator.this.ws)) {
                        launcher.getListener().getLogger().println("JENKINS-33510: working directory will be " + Decorator.this.ws + " not " + path);
                    }
                    TreeSet<String> envReduced = new TreeSet<String>(Arrays.asList(starter.envs()));
                    envReduced.removeAll(Arrays.asList(Decorator.this.envHost));
                    prefix.addAll(envReduced);
                    starter.cmds().addAll(0, prefix);
                    if (starter.masks() != null) {
                        boolean[] masks = new boolean[starter.masks().length + prefix.size()];
                        System.arraycopy(starter.masks(), 0, masks, prefix.size(), starter.masks().length);
                        starter.masks(masks);
                    }
                    return super.launch(starter);
                }

                public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    String executable = this.getExecutable();
                    if (this.getInner().launch().cmds(new String[]{executable, "exec", Decorator.this.container, "ps", "-A", "-o", "pid,command", "e"}).stdout((OutputStream)baos).quiet(true).join() != 0) {
                        throw new IOException("failed to run ps");
                    }
                    ArrayList<String> pids = new ArrayList<String>();
                    block0: for (String line : baos.toString(Charset.defaultCharset().name()).split("\n")) {
                        for (Map.Entry<String, String> entry : modelEnvVars.entrySet()) {
                            if (line.contains(entry.getKey() + "=" + entry.getValue())) continue;
                            continue block0;
                        }
                        int spc = (line = line.trim()).indexOf(32);
                        if (spc == -1) continue;
                        pids.add(line.substring(0, spc));
                    }
                    LOGGER.log(Level.FINE, "killing {0}", pids);
                    if (!pids.isEmpty()) {
                        ArrayList<String> cmds = new ArrayList<String>(Arrays.asList(executable, "exec", Decorator.this.container, "kill"));
                        cmds.addAll(pids);
                        if (this.getInner().launch().cmds(cmds).quiet(true).join() != 0) {
                            throw new IOException("failed to run kill");
                        }
                    }
                }

                private String getExecutable() throws IOException, InterruptedException {
                    EnvVars env = new EnvVars();
                    for (String pair : Decorator.this.envHost) {
                        env.addLine(pair);
                    }
                    return DockerTool.getExecutable((String)Decorator.this.toolName, (Node)node, (TaskListener)this.getListener(), (EnvVars)env);
                }
            };
        }
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient WithContainerStep step;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient EnvVars env;
        @StepContextParameter
        private transient Computer computer;
        @StepContextParameter
        private transient Node node;
        @StepContextParameter
        private transient Run run;
        private String container;
        private String toolName;

        public boolean start() throws Exception {
            EnvVars envReduced = new EnvVars(this.env);
            EnvVars envHost = this.computer.getEnvironment();
            envReduced.entrySet().removeAll(envHost.entrySet());
            LOGGER.log(Level.FINE, "reduced environment: {0}", envReduced);
            this.workspace.mkdirs();
            String ws = this.workspace.getRemote();
            this.toolName = this.step.toolName;
            DockerClient dockerClient = new DockerClient(this.launcher, this.node, this.toolName);
            VersionNumber dockerVersion = dockerClient.version();
            if (dockerVersion != null) {
                if (dockerVersion.isOlderThan(new VersionNumber("1.4"))) {
                    throw new AbortException("The docker version is less than v1.4. Pipeline functions requiring 'docker exec' will not work e.g. 'docker.inside'.");
                }
            } else {
                this.listener.error("Failed to parse docker version. Please note there is a minimum docker version requirement of v1.4.");
            }
            FilePath tempDir = Execution.tempDir(this.workspace);
            tempDir.mkdirs();
            String tmp = tempDir.getRemote();
            LinkedHashMap<String, String> volumes = new LinkedHashMap<String, String>();
            LinkedHashSet<String> volumesFromContainers = new LinkedHashSet<String>();
            Optional<String> containerId = dockerClient.getContainerIdIfContainerized();
            if (containerId.isPresent()) {
                String[] dirs;
                List<String> mountedVolumes = dockerClient.getVolumes(envHost, (String)containerId.get());
                for (String dir : dirs = new String[]{ws, tmp}) {
                    boolean found = false;
                    for (String vol : mountedVolumes) {
                        if (!dir.startsWith(vol)) continue;
                        volumesFromContainers.add((String)containerId.get());
                        found = true;
                        break;
                    }
                    if (found) continue;
                    volumes.put(dir, dir);
                }
            } else {
                volumes.put(ws, ws);
                volumes.put(tmp, tmp);
            }
            this.container = dockerClient.run(this.env, this.step.image, this.step.args, ws, volumes, volumesFromContainers, envReduced, dockerClient.whoAmI(), "cat");
            DockerFingerprints.addRunFacet((ContainerRecord)dockerClient.getContainerRecord(this.env, this.container), (Run)this.run);
            ImageAction.add(this.step.image, this.run);
            this.getContext().newBodyInvoker().withContext((Object)BodyInvoker.mergeLauncherDecorators((LauncherDecorator)((LauncherDecorator)this.getContext().get(LauncherDecorator.class)), (LauncherDecorator)new Decorator(this.container, envHost, ws, this.toolName))).withCallback((BodyExecutionCallback)new Callback(this.container, this.toolName)).start();
            return false;
        }

        private static FilePath tempDir(FilePath ws) {
            return ws.sibling(ws.getName() + System.getProperty(WorkspaceList.class.getName(), "@") + "tmp");
        }

        public void stop(@Nonnull Throwable cause) throws Exception {
            if (this.container != null) {
                LOGGER.log(Level.FINE, "stopping container " + this.container, cause);
                WithContainerStep.destroy(this.container, this.launcher, (Node)this.getContext().get(Node.class), this.env, this.toolName);
            }
        }
    }
}

