/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

public enum ConnectionStrategy {
    PUBLIC_DNS("Public DNS"),
    PUBLIC_IP("Public IP"),
    PRIVATE_DNS("Private DNS"),
    PRIVATE_IP("Private IP");

    private final String displayText;

    private ConnectionStrategy(String displayText) {
        this.displayText = displayText;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public static ConnectionStrategy backwardsCompatible(boolean usePrivateDnsName, boolean connectUsingPublicIp, boolean associatePublicIp) {
        if (usePrivateDnsName && !connectUsingPublicIp) {
            return PRIVATE_DNS;
        }
        if (connectUsingPublicIp || associatePublicIp) {
            return PUBLIC_IP;
        }
        return PRIVATE_IP;
    }
}

