/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.services.ec2.model.Instance;
import hudson.plugins.ec2.ConnectionStrategy;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class EC2HostAddressProvider {
    public static String unix(Instance instance, ConnectionStrategy strategy) {
        switch (strategy) {
            case PUBLIC_DNS: {
                return EC2HostAddressProvider.filterNonEmpty(EC2HostAddressProvider.getPublicDnsName(instance)).orElse(EC2HostAddressProvider.getPublicIpAddress(instance));
            }
            case PUBLIC_IP: {
                return EC2HostAddressProvider.getPublicIpAddress(instance);
            }
            case PRIVATE_DNS: {
                return EC2HostAddressProvider.filterNonEmpty(EC2HostAddressProvider.getPrivateDnsName(instance)).orElse(EC2HostAddressProvider.getPrivateIpAddress(instance));
            }
            case PRIVATE_IP: {
                return EC2HostAddressProvider.getPrivateIpAddress(instance);
            }
        }
        throw new IllegalArgumentException("Could not unix host address for strategy = " + strategy.toString());
    }

    public static String mac(Instance instance, ConnectionStrategy strategy) {
        switch (strategy) {
            case PUBLIC_DNS: {
                return EC2HostAddressProvider.filterNonEmpty(EC2HostAddressProvider.getPublicDnsName(instance)).orElse(EC2HostAddressProvider.getPublicIpAddress(instance));
            }
            case PUBLIC_IP: {
                return EC2HostAddressProvider.getPublicIpAddress(instance);
            }
            case PRIVATE_DNS: {
                return EC2HostAddressProvider.filterNonEmpty(EC2HostAddressProvider.getPrivateDnsName(instance)).orElse(EC2HostAddressProvider.getPrivateIpAddress(instance));
            }
            case PRIVATE_IP: {
                return EC2HostAddressProvider.getPrivateIpAddress(instance);
            }
        }
        throw new IllegalArgumentException("Could not mac host address for strategy = " + strategy.toString());
    }

    public static String windows(Instance instance, ConnectionStrategy strategy) {
        if (strategy.equals((Object)ConnectionStrategy.PRIVATE_DNS) || strategy.equals((Object)ConnectionStrategy.PRIVATE_IP)) {
            return EC2HostAddressProvider.getPrivateIpAddress(instance);
        }
        if (strategy.equals((Object)ConnectionStrategy.PUBLIC_DNS) || strategy.equals((Object)ConnectionStrategy.PUBLIC_IP)) {
            return EC2HostAddressProvider.getPublicIpAddress(instance);
        }
        throw new IllegalArgumentException("Could not windows host address for strategy = " + strategy.toString());
    }

    private static String getPublicDnsName(Instance instance) {
        return instance.getPublicDnsName();
    }

    private static String getPublicIpAddress(Instance instance) {
        return instance.getPublicIpAddress();
    }

    private static String getPrivateDnsName(Instance instance) {
        return instance.getPrivateDnsName();
    }

    private static String getPrivateIpAddress(Instance instance) {
        return instance.getPrivateIpAddress();
    }

    private static Optional<String> filterNonEmpty(String value) {
        return Optional.ofNullable(value).filter(StringUtils::isNotEmpty);
    }
}

