/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Computer;
import hudson.model.Queue;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.util.MinimumNumberOfInstancesTimeRangeConfig;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class MinimumInstanceChecker {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Needs to be overridden from tests")
    public static Clock clock = Clock.systemDefaultZone();

    private static Stream<Computer> agentsForTemplate(@NonNull SlaveTemplate agentTemplate) {
        return Arrays.stream(Jenkins.get().getComputers()).filter(computer -> computer instanceof EC2Computer).filter(computer -> {
            SlaveTemplate computerTemplate = ((EC2Computer)((Object)computer)).getSlaveTemplate();
            return computerTemplate != null && Objects.equals(computerTemplate.description, agentTemplate.description);
        });
    }

    public static int countCurrentNumberOfAgents(@NonNull SlaveTemplate agentTemplate) {
        return (int)MinimumInstanceChecker.agentsForTemplate(agentTemplate).count();
    }

    public static int countCurrentNumberOfSpareAgents(@NonNull SlaveTemplate agentTemplate) {
        return (int)MinimumInstanceChecker.agentsForTemplate(agentTemplate).filter(computer -> computer.countBusy() == 0).filter(computer -> computer.isOnline()).count();
    }

    public static int countCurrentNumberOfProvisioningAgents(@NonNull SlaveTemplate agentTemplate) {
        return (int)MinimumInstanceChecker.agentsForTemplate(agentTemplate).filter(computer -> computer.countBusy() == 0).filter(computer -> computer.isOffline()).filter(computer -> computer.isConnecting()).count();
    }

    public static int countQueueItemsForAgentTemplate(@NonNull SlaveTemplate agentTemplate) {
        return (int)Queue.getInstance().getBuildableItems().stream().map(item -> item.getAssignedLabel()).filter(Objects::nonNull).filter(label -> label.matches(agentTemplate.getLabelSet())).count();
    }

    public static void checkForMinimumInstances() {
        Jenkins.get().clouds.stream().filter(cloud -> cloud instanceof EC2Cloud).map(cloud -> (EC2Cloud)((Object)cloud)).forEach(cloud -> cloud.getTemplates().forEach(agentTemplate -> {
            int numberToProvision;
            if (!MinimumInstanceChecker.minimumInstancesActive(agentTemplate.getMinimumNumberOfInstancesTimeRangeConfig())) {
                return;
            }
            int requiredMinAgents = agentTemplate.getMinimumNumberOfInstances();
            int requiredMinSpareAgents = agentTemplate.getMinimumNumberOfSpareInstances();
            int currentNumberOfAgentsForTemplate = MinimumInstanceChecker.countCurrentNumberOfAgents(agentTemplate);
            int currentNumberOfSpareAgentsForTemplate = MinimumInstanceChecker.countCurrentNumberOfSpareAgents(agentTemplate);
            int currentNumberOfProvisioningAgentsForTemplate = MinimumInstanceChecker.countCurrentNumberOfProvisioningAgents(agentTemplate);
            int currentBuildsWaitingForTemplate = MinimumInstanceChecker.countQueueItemsForAgentTemplate(agentTemplate);
            int provisionForMinAgents = 0;
            int provisionForMinSpareAgents = 0;
            provisionForMinAgents = requiredMinAgents - currentNumberOfAgentsForTemplate;
            if (provisionForMinAgents < 0) {
                provisionForMinAgents = 0;
            }
            if ((provisionForMinSpareAgents = requiredMinSpareAgents + currentBuildsWaitingForTemplate - (currentNumberOfSpareAgentsForTemplate + provisionForMinAgents + currentNumberOfProvisioningAgentsForTemplate)) < 0) {
                provisionForMinSpareAgents = 0;
            }
            if ((numberToProvision = provisionForMinAgents + provisionForMinSpareAgents) > 0) {
                cloud.provision((SlaveTemplate)agentTemplate, numberToProvision);
            }
        }));
    }

    public static boolean minimumInstancesActive(MinimumNumberOfInstancesTimeRangeConfig minimumNumberOfInstancesTimeRangeConfig) {
        if (minimumNumberOfInstancesTimeRangeConfig == null) {
            return true;
        }
        LocalTime fromTime = minimumNumberOfInstancesTimeRangeConfig.getMinimumNoInstancesActiveTimeRangeFromAsTime();
        LocalTime toTime = minimumNumberOfInstancesTimeRangeConfig.getMinimumNoInstancesActiveTimeRangeToAsTime();
        LocalDateTime now = LocalDateTime.now(clock);
        LocalTime nowTime = LocalTime.from(now);
        boolean passingMidnight = false;
        if (toTime.isBefore(fromTime)) {
            passingMidnight = true;
        }
        if (passingMidnight) {
            if (nowTime.isAfter(fromTime)) {
                String today = now.getDayOfWeek().name().toLowerCase();
                return minimumNumberOfInstancesTimeRangeConfig.getDay(today);
            }
            if (nowTime.isBefore(toTime)) {
                String yesterday = now.minusDays(1L).getDayOfWeek().name().toLowerCase();
                return minimumNumberOfInstancesTimeRangeConfig.getDay(yesterday);
            }
        } else if (nowTime.isAfter(fromTime) && nowTime.isBefore(toTime)) {
            String today = now.getDayOfWeek().name().toLowerCase();
            return minimumNumberOfInstancesTimeRangeConfig.getDay(today);
        }
        return false;
    }
}

