/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt.global;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class CredentialsHelper {
    public static ListBoxModel doFillCredentialsIdItems(Item item, String credentialsId) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null ? !Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return result.includeCurrentValue(credentialsId);
        }
        return result.includeEmptyValue().includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM, item, StringCredentials.class, new ArrayList(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StringCredentials.class)})).includeCurrentValue(credentialsId);
    }

    public static FormValidation doCheckFillCredentialsId(String credentialsId) {
        if (Strings.isNullOrEmpty((String)credentialsId)) {
            return FormValidation.ok();
        }
        if (!CredentialsHelper.findCredentials(credentialsId).isPresent()) {
            return FormValidation.error((String)"Cannot find currently selected credentials");
        }
        return FormValidation.ok();
    }

    public static Optional<StringCredentials> findCredentials(String credentialsId) {
        return CredentialsHelper.findCredentials(credentialsId, null);
    }

    public static Optional<StringCredentials> findCredentials(String credentialsId, Item item) {
        if (Strings.isNullOrEmpty((String)credentialsId)) {
            return Optional.absent();
        }
        Authentication authentication = null;
        ArrayList domainRequirements = new ArrayList();
        List lookupCredentials = CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, authentication, domainRequirements);
        CredentialsMatcher allOf = CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StringCredentials.class)})});
        return Optional.fromNullable((Object)((StringCredentials)CredentialsMatchers.firstOrNull((Iterable)lookupCredentials, (CredentialsMatcher)allOf)));
    }
}

