/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt.jobfinder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import hudson.model.Item;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.gwt.FoundJob;
import org.jenkinsci.plugins.gwt.GenericTrigger;
import org.jenkinsci.plugins.gwt.global.CredentialsHelper;
import org.jenkinsci.plugins.gwt.jobfinder.GenericTriggerFinder;
import org.jenkinsci.plugins.gwt.jobfinder.JobFinderImpersonater;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public final class JobFinder {
    private static Logger LOG = Logger.getLogger(JobFinder.class.getName());
    private static JobFinderImpersonater jobFinderImpersonater = new JobFinderImpersonater();

    private JobFinder() {
    }

    @VisibleForTesting
    static void setJobFinderImpersonater(JobFinderImpersonater jobFinderImpersonater) {
        JobFinder.jobFinderImpersonater = jobFinderImpersonater;
    }

    public static List<FoundJob> findAllJobsWithTrigger(String givenToken) {
        ArrayList<FoundJob> found = new ArrayList<FoundJob>();
        boolean impersonate = !Strings.isNullOrEmpty((String)givenToken);
        List<ParameterizedJobMixIn.ParameterizedJob> candidateProjects = jobFinderImpersonater.getAllParameterizedJobs(impersonate);
        for (ParameterizedJobMixIn.ParameterizedJob candidateJob : candidateProjects) {
            String configuredToken;
            boolean authenticationTokenMatches;
            GenericTrigger genericTriggerOpt = GenericTriggerFinder.findGenericTrigger(candidateJob.getTriggers());
            if (genericTriggerOpt == null || !(authenticationTokenMatches = JobFinder.authenticationTokenMatches(givenToken, configuredToken = JobFinder.determineTokenValue((Item)candidateJob, genericTriggerOpt.getToken(), genericTriggerOpt.getTokenCredentialId())))) continue;
            FoundJob foundJob = new FoundJob(candidateJob.getFullName(), genericTriggerOpt);
            found.add(foundJob);
        }
        return found;
    }

    private static String determineTokenValue(Item item, String token, String tokenCredentialsId) {
        Optional<StringCredentials> credentialsOpt;
        if (Strings.isNullOrEmpty((String)tokenCredentialsId)) {
            LOG.log(Level.FINE, "Found no credential configured in " + item.getFullDisplayName());
            return token;
        }
        if (!Strings.isNullOrEmpty((String)tokenCredentialsId) && !Strings.isNullOrEmpty((String)token)) {
            LOG.log(Level.WARNING, "The job " + item.getFullDisplayName() + " is configured with both static token and token from credential " + tokenCredentialsId + ".");
        }
        if ((credentialsOpt = CredentialsHelper.findCredentials(tokenCredentialsId, item)).isPresent()) {
            LOG.log(Level.FINE, "Found credential from " + tokenCredentialsId + " configured in " + item.getFullDisplayName());
            return ((StringCredentials)credentialsOpt.get()).getSecret().getPlainText();
        }
        LOG.log(Level.SEVERE, "Cannot find credential (" + tokenCredentialsId + ") configured in " + item.getFullDisplayName());
        return token;
    }

    private static boolean authenticationTokenMatches(String givenToken, String configuredToken) {
        boolean noTokenGiven = Strings.isNullOrEmpty((String)givenToken);
        boolean noTokenConfigured = Strings.isNullOrEmpty((String)configuredToken);
        return JobFinder.authenticationTokenMatchesGeneric(configuredToken, givenToken) || noTokenGiven && noTokenConfigured;
    }

    private static boolean authenticationTokenMatchesGeneric(String configuredToken, String givenToken) {
        boolean tokenWasGiven;
        boolean jobHasConfiguredToken = !Strings.isNullOrEmpty((String)configuredToken);
        boolean bl = tokenWasGiven = !Strings.isNullOrEmpty((String)givenToken);
        if (jobHasConfiguredToken && tokenWasGiven) {
            return MessageDigest.isEqual(configuredToken.getBytes(StandardCharsets.UTF_8), givenToken.getBytes(StandardCharsets.UTF_8));
        }
        return !jobHasConfiguredToken && !tokenWasGiven;
    }
}

