/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitBlitRepositoryBrowser;
import hudson.plugins.git.browser.GitChangeSetSample;
import hudson.scm.EditType;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GitBlitRepositoryBrowserTest {
    private final String repoUrl = "http://gitblit.example.com/";
    private final boolean useAuthorName;
    private final GitChangeSetSample sample;
    private final String projectName = "gitBlitProjectName";

    public GitBlitRepositoryBrowserTest(String useAuthorName) {
        this.useAuthorName = Boolean.valueOf(useAuthorName);
        this.sample = new GitChangeSetSample(this.useAuthorName);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection permuteAuthorName() {
        String[] allowed;
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (String authorName : allowed = new String[]{"true", "false"}) {
            Object[] combination = new Object[]{authorName};
            values.add(combination);
        }
        return values;
    }

    @Test
    public void testGetChangeSetLink() throws Exception {
        URL result = new GitBlitRepositoryBrowser("http://gitblit.example.com/", "gitBlitProjectName").getChangeSetLink(this.sample.changeSet);
        Assert.assertEquals((Object)new URL("http://gitblit.example.com/commit?r=gitBlitProjectName&h=" + this.sample.id), (Object)result);
    }

    @Test
    public void testGetDiffLink() throws Exception {
        GitBlitRepositoryBrowser gitblit = new GitBlitRepositoryBrowser("http://gitblit.example.com/", "gitBlitProjectName");
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            EditType editType = path.getEditType();
            Assert.assertTrue((String)("Unexpected edit type " + editType.getName()), (editType == EditType.ADD || editType == EditType.EDIT || editType == EditType.DELETE ? 1 : 0) != 0);
            URL diffLink = gitblit.getDiffLink(path);
            URL expectedDiffLink = new URL("http://gitblit.example.com/blobdiff?r=gitBlitProjectName&h=" + this.sample.id + "&hb=" + this.sample.parent);
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + editType.getName();
            Assert.assertEquals((String)msg, (Object)expectedDiffLink, (Object)diffLink);
        }
    }

    @Test
    public void testGetFileLink() throws Exception {
        GitBlitRepositoryBrowser gitblit = new GitBlitRepositoryBrowser("http://gitblit.example.com/", "gitBlitProjectName");
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            URL fileLink = gitblit.getFileLink(path);
            EditType editType = path.getEditType();
            URL expectedFileLink = null;
            if (editType == EditType.ADD || editType == EditType.EDIT) {
                expectedFileLink = new URL("http://gitblit.example.com/blob?r=gitBlitProjectName&h=" + this.sample.id + "&f=" + URLEncoder.encode(path.getPath(), "UTF-8").replaceAll("\\+", "%20"));
            } else if (editType == EditType.DELETE) {
                expectedFileLink = null;
            } else {
                Assert.fail((String)("Unexpected edit type " + editType.getName()));
            }
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + editType.getName();
            Assert.assertEquals((String)msg, (Object)expectedFileLink, (Object)fileLink);
        }
    }

    @Test
    public void testGetProjectName() {
        GitBlitRepositoryBrowser gitblit = new GitBlitRepositoryBrowser("http://gitblit.example.com/", "gitBlitProjectName");
        Assert.assertEquals((Object)"gitBlitProjectName", (Object)gitblit.getProjectName());
    }
}

