/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.plugins.git.GitStatus;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.plugins.git.GitSCMSource;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockito.Mockito;

public class GitSCMSourceTest {
    public static final String REMOTE = "git@remote:test/project.git";
    @Rule
    public JenkinsRule jenkins = new JenkinsRule();
    private GitStatus gitStatus;

    @Before
    public void setup() {
        this.gitStatus = new GitStatus();
    }

    @Test
    public void testSourceOwnerTriggeredByDoNotifyCommit() throws ServletException, IOException {
        GitSCMSource gitSCMSource = new GitSCMSource("id", REMOTE, "", "*", "", false);
        GitSCMSourceOwner scmSourceOwner = this.setupGitSCMSourceOwner(gitSCMSource);
        this.jenkins.getInstance().add((TopLevelItem)scmSourceOwner, "gitSourceOwner");
        this.gitStatus.doNotifyCommit((HttpServletRequest)Mockito.mock(HttpServletRequest.class), REMOTE, "master", "");
        ((GitSCMSourceOwner)Mockito.verify((Object)scmSourceOwner)).onSCMSourceUpdated((SCMSource)gitSCMSource);
    }

    private GitSCMSourceOwner setupGitSCMSourceOwner(GitSCMSource gitSCMSource) {
        GitSCMSourceOwner owner = (GitSCMSourceOwner)Mockito.mock(GitSCMSourceOwner.class);
        Mockito.when((Object)owner.getSCMSources()).thenReturn(Collections.singletonList(gitSCMSource));
        Mockito.when((Object)owner.hasPermission(Item.READ)).thenReturn((Object)true);
        return owner;
    }

    private static interface GitSCMSourceOwner
    extends TopLevelItem,
    SCMSourceOwner {
    }
}

