/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Messages;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import java.util.Objects;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.SubmoduleUpdateCommand;
import org.jenkinsci.plugins.gitclient.UnsupportedCommand;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SubmoduleOption
extends GitSCMExtension {
    private boolean disableSubmodules;
    private boolean recursiveSubmodules;
    private boolean trackingSubmodules;
    private String reference;
    private boolean parentCredentials;
    private Integer timeout;
    private boolean shallow;
    private Integer depth;
    private Integer threads;

    @DataBoundConstructor
    public SubmoduleOption(boolean disableSubmodules, boolean recursiveSubmodules, boolean trackingSubmodules, String reference, Integer timeout, boolean parentCredentials) {
        this.disableSubmodules = disableSubmodules;
        this.recursiveSubmodules = recursiveSubmodules;
        this.trackingSubmodules = trackingSubmodules;
        this.parentCredentials = parentCredentials;
        this.reference = reference;
        this.timeout = timeout;
    }

    @Whitelisted
    public boolean isDisableSubmodules() {
        return this.disableSubmodules;
    }

    @Whitelisted
    public boolean isRecursiveSubmodules() {
        return this.recursiveSubmodules;
    }

    @Whitelisted
    public boolean isTrackingSubmodules() {
        return this.trackingSubmodules;
    }

    @Whitelisted
    public boolean isParentCredentials() {
        return this.parentCredentials;
    }

    @Whitelisted
    public String getReference() {
        return this.reference;
    }

    @Whitelisted
    public Integer getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setShallow(boolean shallow) {
        this.shallow = shallow;
    }

    @Whitelisted
    public boolean getShallow() {
        return this.shallow;
    }

    @DataBoundSetter
    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    @Whitelisted
    public Integer getDepth() {
        return this.depth;
    }

    @Whitelisted
    public Integer getThreads() {
        return this.threads;
    }

    @DataBoundSetter
    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    @Override
    public void onClean(GitSCM scm, GitClient git) throws IOException, InterruptedException, GitException {
        if (!this.disableSubmodules && git.hasGitModules()) {
            git.submoduleClean(this.recursiveSubmodules);
        }
    }

    @Override
    public void onCheckoutCompleted(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener) throws IOException, InterruptedException, GitException {
        BuildData revToBuild = scm.getBuildData(build);
        try {
            if (!this.disableSubmodules && git.hasGitModules() && revToBuild != null && revToBuild.lastBuild != null) {
                git.setupSubmoduleUrls(revToBuild.lastBuild.getRevision(), listener);
                SubmoduleUpdateCommand cmd = git.submoduleUpdate().recursive(this.recursiveSubmodules).remoteTracking(this.trackingSubmodules).parentCredentials(this.parentCredentials).ref(build.getEnvironment(listener).expand(this.reference)).timeout(this.timeout).shallow(this.shallow);
                if (this.shallow) {
                    int usedDepth = this.depth == null || this.depth < 1 ? 1 : this.depth;
                    listener.getLogger().println("Using shallow submodule update with depth " + usedDepth);
                    cmd.depth(Integer.valueOf(usedDepth));
                }
                int usedThreads = this.threads == null || this.threads < 1 ? 1 : this.threads;
                cmd.threads(usedThreads);
                cmd.execute();
            }
        }
        catch (GitException e) {
            throw new IOException("Could not perform submodule update", e);
        }
    }

    @Override
    public void determineSupportForJGit(GitSCM scm, @NonNull UnsupportedCommand cmd) {
        if (this.threads == null) {
            cmd.threads(Integer.valueOf(1));
        } else {
            cmd.threads(this.threads);
        }
        cmd.depth(this.depth);
        cmd.shallow(this.shallow);
        cmd.timeout(this.timeout);
        cmd.ref(this.reference);
        cmd.parentCredentials(this.parentCredentials);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SubmoduleOption that = (SubmoduleOption)((Object)o);
        return this.disableSubmodules == that.disableSubmodules && this.recursiveSubmodules == that.recursiveSubmodules && this.trackingSubmodules == that.trackingSubmodules && this.parentCredentials == that.parentCredentials && Objects.equals(this.reference, that.reference) && Objects.equals(this.timeout, that.timeout) && this.shallow == that.shallow && Objects.equals(this.depth, that.depth) && Objects.equals(this.threads, that.threads);
    }

    public int hashCode() {
        return Objects.hash(this.disableSubmodules, this.recursiveSubmodules, this.trackingSubmodules, this.parentCredentials, this.reference, this.timeout, this.shallow, this.depth, this.threads);
    }

    public String toString() {
        return "SubmoduleOption{disableSubmodules=" + this.disableSubmodules + ", recursiveSubmodules=" + this.recursiveSubmodules + ", trackingSubmodules=" + this.trackingSubmodules + ", reference='" + this.reference + '\'' + ", parentCredentials=" + this.parentCredentials + ", timeout=" + this.timeout + ", shallow=" + this.shallow + ", depth=" + this.depth + ", threads=" + this.threads + '}';
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return Messages.advanced_sub_modules_behaviours();
        }
    }
}

