/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.model.UnprotectedRootAction;
import hudson.plugins.git.ApiTokenPropertyConfiguration;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.scm.api.SCMEvent;
import jenkins.triggers.SCMTriggerItem;
import jenkins.util.SystemProperties;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class GitStatus
implements UnprotectedRootAction {
    static String NOTIFY_COMMIT_ACCESS_CONTROL = SystemProperties.getString((String)(GitStatus.class.getName() + ".NOTIFY_COMMIT_ACCESS_CONTROL"));
    private String lastURL = "";
    private String lastBranches = null;
    private String lastSHA1 = null;
    private List<ParameterValue> lastBuildParameters = null;
    private static List<ParameterValue> lastStaticBuildParameters = null;
    public static final Pattern SHA1_PATTERN = Pattern.compile("[a-fA-F0-9]++");
    public static final Pattern CLEANER_SHA1_PATTERN = Pattern.compile("[^a-fA-F0-9]");
    private static final Logger LOGGER = Logger.getLogger(GitStatus.class.getName());
    private static final int MAX_REPORTED_CONTRIBUTORS = 10;
    public static final boolean ALLOW_NOTIFY_COMMIT_PARAMETERS;
    private static boolean allowNotifyCommitParameters;
    public static final String SAFE_PARAMETERS;
    private static Set<String> safeParameters;

    public String getDisplayName() {
        return "Git";
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "git";
    }

    static void setAllowNotifyCommitParameters(boolean allowed) {
        allowNotifyCommitParameters = allowed;
    }

    private static void clearLastStaticBuildParameters() {
        lastStaticBuildParameters = null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("URL: ");
        s.append(this.lastURL);
        if (this.lastSHA1 != null) {
            s.append(" SHA1: ");
            s.append(this.lastSHA1);
        }
        if (this.lastBranches != null) {
            s.append(" Branches: ");
            s.append(this.lastBranches);
        }
        if (this.lastBuildParameters != null && !this.lastBuildParameters.isEmpty()) {
            s.append(" Parameters: ");
            for (ParameterValue buildParameter : this.lastBuildParameters) {
                s.append(buildParameter.getName());
                s.append("='");
                s.append(buildParameter.getValue());
                s.append("',");
            }
            s.delete(s.length() - 1, s.length());
        }
        if (lastStaticBuildParameters != null && !lastStaticBuildParameters.isEmpty()) {
            s.append(" More parameters: ");
            for (ParameterValue buildParameter : lastStaticBuildParameters) {
                s.append(buildParameter.getName());
                s.append("='");
                s.append(buildParameter.getValue());
                s.append("',");
            }
            s.delete(s.length() - 1, s.length());
        }
        return s.toString();
    }

    public HttpResponse doNotifyCommit(HttpServletRequest request, @QueryParameter(required=true) String url, @QueryParameter String branches, @QueryParameter String sha1, @QueryParameter String token) {
        URIish uri;
        if (!"disabled".equalsIgnoreCase(NOTIFY_COMMIT_ACCESS_CONTROL) && !"disabled-for-polling".equalsIgnoreCase(NOTIFY_COMMIT_ACCESS_CONTROL)) {
            if (token == null || token.isEmpty()) {
                return HttpResponses.errorWithoutStack((int)401, (String)"An access token is required. Please refer to Git plugin documentation (https://plugins.jenkins.io/git/#plugin-content-push-notification-from-repository) for details.");
            }
            if (!ApiTokenPropertyConfiguration.get().isValidApiToken(token)) {
                return HttpResponses.errorWithoutStack((int)403, (String)"Invalid access token");
            }
        }
        if ("disabled-for-polling".equalsIgnoreCase(NOTIFY_COMMIT_ACCESS_CONTROL) && sha1 != null && !sha1.isEmpty()) {
            if (token == null || token.isEmpty()) {
                return HttpResponses.errorWithoutStack((int)401, (String)"An access token is required when using the sha1 parameter. Please refer to Git plugin documentation (https://plugins.jenkins.io/git/#plugin-content-push-notification-from-repository) for details.");
            }
            if (!ApiTokenPropertyConfiguration.get().isValidApiToken(token)) {
                return HttpResponses.errorWithoutStack((int)403, (String)"Invalid access token");
            }
        }
        this.lastURL = url;
        this.lastBranches = branches;
        if (sha1 != null && !sha1.isBlank() && !SHA1_PATTERN.matcher(sha1.trim()).matches()) {
            return HttpResponses.error((int)400, (Throwable)new IllegalArgumentException("Illegal SHA1"));
        }
        this.lastSHA1 = GitStatus.cleanupSha1(sha1);
        this.lastBuildParameters = null;
        GitStatus.clearLastStaticBuildParameters();
        ArrayList<ParameterValue> buildParameters = new ArrayList<ParameterValue>();
        try {
            uri = new URIish(url);
        }
        catch (URISyntaxException e) {
            return HttpResponses.error((int)400, (Throwable)new Exception("Illegal URL: " + url, e));
        }
        if (allowNotifyCommitParameters || !safeParameters.isEmpty()) {
            Map parameterMap = request.getParameterMap();
            for (Map.Entry entry : parameterMap.entrySet()) {
                if (((String)entry.getKey()).equals("url") || ((String)entry.getKey()).equals("branches") || ((String)entry.getKey()).equals("sha1") || ((String[])entry.getValue())[0] == null || !allowNotifyCommitParameters && !safeParameters.contains(entry.getKey())) continue;
                buildParameters.add((ParameterValue)new StringParameterValue((String)entry.getKey(), ((String[])entry.getValue())[0]));
            }
        }
        this.lastBuildParameters = buildParameters;
        String[] branchesArray = (branches = Util.fixEmptyAndTrim((String)branches)) == null ? new String[]{} : branches.split(",");
        final ArrayList<ResponseContributor> contributors = new ArrayList<ResponseContributor>();
        Jenkins jenkins = Jenkins.get();
        String origin = SCMEvent.originOf((HttpServletRequest)request);
        for (Listener listener : jenkins.getExtensionList(Listener.class)) {
            contributors.addAll(listener.onNotifyCommit(origin, uri, sha1, buildParameters, branchesArray));
        }
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException {
                rsp.setStatus(200);
                rsp.setContentType("text/plain");
                for (int i = 0; i < contributors.size(); ++i) {
                    if (i == 10) {
                        rsp.addHeader("Triggered", "<" + (contributors.size() - i) + " more>");
                        break;
                    }
                    ((ResponseContributor)contributors.get(i)).addHeaders(req, rsp);
                }
                PrintWriter w = rsp.getWriter();
                for (ResponseContributor c : contributors) {
                    c.writeBody(req, rsp, w);
                }
            }
        };
    }

    public static boolean looselyMatches(URIish lhs, URIish rhs) {
        return Objects.equals(lhs.getHost(), rhs.getHost()) && Objects.equals(GitStatus.normalizePath(lhs.getPath()), GitStatus.normalizePath(rhs.getPath()));
    }

    private static String normalizePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith(".git")) {
            path = path.substring(0, path.length() - 4);
        }
        return path;
    }

    private static String cleanupSha1(String sha1) {
        return sha1 == null ? null : CLEANER_SHA1_PATTERN.matcher(sha1.trim()).replaceAll("");
    }

    static void setSafeParametersForTest(String parameters) {
        safeParameters = GitStatus.csvToSet(parameters != null ? parameters : SAFE_PARAMETERS);
    }

    private static Set<String> csvToSet(String csvLine) {
        String[] tokens = csvLine.split(",");
        HashSet<String> set = new HashSet<String>(Arrays.asList(tokens));
        return set;
    }

    @NonNull
    private static String getSafeParameters() {
        String globalSafeParameters = System.getProperty("hudson.model.ParametersAction.safeParameters", "").trim();
        String gitStatusSafeParameters = System.getProperty(GitStatus.class.getName() + ".safeParameters", "").trim();
        if (globalSafeParameters.isEmpty()) {
            return gitStatusSafeParameters;
        }
        if (gitStatusSafeParameters.isEmpty()) {
            return globalSafeParameters;
        }
        return globalSafeParameters + "," + gitStatusSafeParameters;
    }

    static {
        allowNotifyCommitParameters = ALLOW_NOTIFY_COMMIT_PARAMETERS = Boolean.valueOf(System.getProperty(GitStatus.class.getName() + ".allowNotifyCommitParameters", "false")) != false || Boolean.valueOf(System.getProperty("hudson.model.ParametersAction.keepUndefinedParameters", "false")) != false;
        SAFE_PARAMETERS = GitStatus.getSafeParameters();
        safeParameters = GitStatus.csvToSet(SAFE_PARAMETERS);
    }

    public static class CommitHookCause
    extends Cause {
        public final String sha1;

        public CommitHookCause(String sha1) {
            this.sha1 = GitStatus.cleanupSha1(sha1);
        }

        public String getShortDescription() {
            return "commit notification " + GitStatus.cleanupSha1(this.sha1);
        }
    }

    public static class MessageResponseContributor
    extends ResponseContributor {
        private final String msg;

        public MessageResponseContributor(String msg) {
            this.msg = msg;
        }

        @Override
        public void writeBody(PrintWriter w) {
            w.println(this.msg);
        }
    }

    @Extension
    public static class JenkinsAbstractProjectListener
    extends Listener {
        @Override
        public List<ResponseContributor> onNotifyCommit(String origin, URIish uri, String sha1, List<ParameterValue> buildParameters, String ... branches) {
            sha1 = GitStatus.cleanupSha1(sha1);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Received notification from {0} for uri = {1} ; sha1 = {2} ; branches = {3}", new Object[]{StringUtils.defaultIfBlank((String)origin, (String)"?"), uri, sha1, Arrays.toString(branches)});
            }
            GitStatus.clearLastStaticBuildParameters();
            ArrayList<ParameterValue> allBuildParameters = new ArrayList<ParameterValue>(buildParameters);
            ArrayList<ResponseContributor> result = new ArrayList<ResponseContributor>();
            try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
                boolean scmFound = false;
                boolean urlFound = false;
                Jenkins jenkins = Jenkins.getInstanceOrNull();
                if (jenkins == null) {
                    LOGGER.severe("Jenkins.getInstance() is null in GitStatus.onNotifyCommit");
                    ArrayList<ResponseContributor> arrayList = result;
                    return arrayList;
                }
                block6: for (Item project : jenkins.getAllItems()) {
                    SCMTriggerItem scmTriggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)project);
                    if (scmTriggerItem == null) continue;
                    block7: for (SCM scm : scmTriggerItem.getSCMs()) {
                        if (!(scm instanceof GitSCM)) continue;
                        GitSCM git = (GitSCM)scm;
                        scmFound = true;
                        for (RemoteConfig repository : git.getRepositories()) {
                            boolean repositoryMatches = false;
                            boolean branchMatches = false;
                            URIish matchedURL = null;
                            for (URIish remoteURL : repository.getURIs()) {
                                if (!GitStatus.looselyMatches(uri, remoteURL)) continue;
                                repositoryMatches = true;
                                matchedURL = remoteURL;
                                break;
                            }
                            if (!repositoryMatches || git.getExtensions().get(IgnoreNotifyCommit.class) != null) continue;
                            SCMTrigger trigger = scmTriggerItem.getSCMTrigger();
                            if (trigger == null || trigger.isIgnorePostCommitHooks()) {
                                if (!LOGGER.isLoggable(Level.FINE)) continue;
                                LOGGER.log(Level.FINE, "no trigger, or post-commit hooks disabled, on {0}", project.getFullDisplayName());
                                continue;
                            }
                            boolean branchFound = false;
                            boolean parametrizedBranchSpec = false;
                            if (branches.length == 0) {
                                branchFound = true;
                            } else {
                                block10: for (BranchSpec branchSpec : git.getBranches()) {
                                    if (branchSpec.getName().contains("$")) {
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.log(Level.FINE, "Branch Spec is parametrized for {0}", project.getFullDisplayName());
                                        }
                                        branchFound = true;
                                        parametrizedBranchSpec = true;
                                        continue;
                                    }
                                    for (String branch : branches) {
                                        if (!branchSpec.matchesRepositoryBranch(repository.getName(), branch)) continue;
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.log(Level.FINE, "Branch Spec {0} matches modified branch {1} for {2}", new Object[]{branchSpec, branch, project.getFullDisplayName()});
                                        }
                                        branchFound = true;
                                        break block10;
                                    }
                                }
                            }
                            if (!branchFound) continue;
                            urlFound = true;
                            if (project instanceof ParameterizedJobMixIn.ParameterizedJob && ((ParameterizedJobMixIn.ParameterizedJob)project).isDisabled()) continue block7;
                            if (project instanceof Job) {
                                HashSet<String> buildParametersNames = new HashSet<String>();
                                if (allowNotifyCommitParameters || !safeParameters.isEmpty()) {
                                    for (ParameterValue parameterValue : allBuildParameters) {
                                        if (!allowNotifyCommitParameters && !safeParameters.contains(parameterValue.getName())) continue;
                                        buildParametersNames.add(parameterValue.getName());
                                    }
                                }
                                ArrayList<ParameterValue> arrayList = this.getDefaultParametersValues((Job)project);
                                for (ParameterValue defaultParameterValue : arrayList) {
                                    if (buildParametersNames.contains(defaultParameterValue.getName())) continue;
                                    allBuildParameters.add(defaultParameterValue);
                                }
                            }
                            if (!parametrizedBranchSpec && sha1 != null && !sha1.isEmpty()) {
                                LOGGER.log(Level.INFO, "Scheduling {0} to build commit {1}", new Object[]{project.getFullDisplayName(), sha1});
                                scmTriggerItem.scheduleBuild2(scmTriggerItem.getQuietPeriod(), new Action[]{new CauseAction((Cause)new CommitHookCause(sha1)), new RevisionParameterAction(sha1, matchedURL), new ParametersAction(allBuildParameters)});
                                result.add(new ScheduledResponseContributor(project));
                                continue block7;
                            }
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "Triggering the polling of {0}", project.getFullDisplayName());
                            }
                            trigger.run();
                            result.add(new PollingScheduledResponseContributor(project));
                            continue block6;
                        }
                    }
                }
                if (!scmFound) {
                    result.add(new MessageResponseContributor("No git jobs found"));
                } else if (!urlFound) {
                    result.add(new MessageResponseContributor("No git jobs using repository: " + uri.toString() + " and branches: " + String.join((CharSequence)",", branches)));
                }
                lastStaticBuildParameters = allBuildParameters;
                ArrayList<ResponseContributor> arrayList = result;
                return arrayList;
            }
        }

        private ArrayList<ParameterValue> getDefaultParametersValues(Job<?, ?> job) {
            ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
            if (paramDefProp == null) {
                ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
                return defValues;
            }
            List parameterDefinition = paramDefProp.getParameterDefinitions();
            ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>(parameterDefinition.size());
            for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
                ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
                if (defaultValue == null) continue;
                defValues.add(defaultValue);
            }
            return defValues;
        }

        private static class ScheduledResponseContributor
        extends ResponseContributor {
            private final Item project;

            public ScheduledResponseContributor(Item project) {
                this.project = project;
            }

            @Override
            public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                rsp.addHeader("Triggered", this.project.getAbsoluteUrl());
            }

            @Override
            public void writeBody(PrintWriter w) {
                w.println("Scheduled " + this.project.getFullDisplayName());
            }
        }

        private static class PollingScheduledResponseContributor
        extends ResponseContributor {
            private final Item project;

            public PollingScheduledResponseContributor(Item project) {
                this.project = project;
            }

            @Override
            public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                rsp.addHeader("Triggered", this.project.getAbsoluteUrl());
            }

            @Override
            public void writeBody(PrintWriter w) {
                w.println("Scheduled polling of " + this.project.getFullDisplayName());
            }
        }
    }

    public static abstract class Listener
    implements ExtensionPoint {
        @Deprecated
        public List<ResponseContributor> onNotifyCommit(URIish uri, String[] branches) {
            throw new AbstractMethodError();
        }

        @Deprecated
        public List<ResponseContributor> onNotifyCommit(URIish uri, @Nullable String sha1, String ... branches) {
            return this.onNotifyCommit(uri, branches);
        }

        @Deprecated
        public List<ResponseContributor> onNotifyCommit(URIish uri, @Nullable String sha1, List<ParameterValue> buildParameters, String ... branches) {
            return this.onNotifyCommit(uri, sha1, branches);
        }

        public List<ResponseContributor> onNotifyCommit(@CheckForNull String origin, URIish uri, @Nullable String sha1, List<ParameterValue> buildParameters, String ... branches) {
            return this.onNotifyCommit(uri, sha1, buildParameters, branches);
        }
    }

    public static class ResponseContributor {
        public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
        }

        public void writeBody(StaplerRequest req, StaplerResponse rsp, PrintWriter w) {
            this.writeBody(w);
        }

        public void writeBody(PrintWriter w) {
        }
    }
}

