/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.git.GitRevisionTokenMacro;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class GitRevisionTokenMacroTest {
    private GitRevisionTokenMacro tokenMacro;

    @Before
    public void createTokenMacro() {
        this.tokenMacro = new GitRevisionTokenMacro();
    }

    @Test
    public void testAcceptsMacroName() {
        Assert.assertTrue((boolean)this.tokenMacro.acceptsMacroName("GIT_REVISION"));
    }

    @Test
    public void testAcceptsMacroNameFalse() {
        Assert.assertFalse((boolean)this.tokenMacro.acceptsMacroName("NOT_A_GIT_REVISION"));
    }

    @Test(expected=NullPointerException.class)
    public void testEvaluate() throws Exception {
        this.tokenMacro.evaluate(null, TaskListener.NULL, "GIT_REVISION");
    }

    @Test
    public void testEvaluateMockBuildNull() throws Exception {
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)((BuildData)build.getAction(BuildData.class))).thenReturn(null);
        MatcherAssert.assertThat((Object)this.tokenMacro.evaluate(build, TaskListener.NULL, "GIT_REVISION"), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void testEvaluateMockBuildDataNull() throws Exception {
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn(null);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)((BuildData)build.getAction(BuildData.class))).thenReturn((Object)buildData);
        MatcherAssert.assertThat((Object)this.tokenMacro.evaluate(build, TaskListener.NULL, "GIT_REVISION"), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void testEvaluateMockBuildData() throws Exception {
        Revision revision = new Revision(ObjectId.fromString((String)"42ab63c2d69c012122d9b373450404244cc58e81"));
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)((BuildData)build.getAction(BuildData.class))).thenReturn((Object)buildData);
        MatcherAssert.assertThat((Object)this.tokenMacro.evaluate(build, TaskListener.NULL, "GIT_REVISION"), (Matcher)Matchers.is((Object)revision.getSha1String()));
    }

    @Test
    public void testEvaluateMockBuildDataLength() throws Exception {
        Revision revision = new Revision(ObjectId.fromString((String)"42ab63c2d69c012122d9b373450404244cc58e81"));
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        Mockito.when((Object)buildData.getLastBuiltRevision()).thenReturn((Object)revision);
        AbstractBuild build = (AbstractBuild)Mockito.mock(AbstractBuild.class);
        Mockito.when((Object)((BuildData)build.getAction(BuildData.class))).thenReturn((Object)buildData);
        this.tokenMacro.length = 8;
        MatcherAssert.assertThat((Object)this.tokenMacro.evaluate(build, TaskListener.NULL, "GIT_REVISION"), (Matcher)Matchers.is((Object)revision.getSha1String().substring(0, 8)));
    }
}

