/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.RevisionParameterAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RevisionParameterActionRemoteUrlTest {
    @Test
    public void noRemoteURLSet() throws Exception {
        RevisionParameterAction target = new RevisionParameterAction("sha1");
        URIish remoteURL = new URIish("https://github.com/jenkinsci/git-plugin.git");
        Assert.assertTrue((String)"should always return true when no remote set", (boolean)target.canOriginateFrom(this.remotes(remoteURL)));
    }

    @Test
    public void remoteURLSetButDoesntMatch() throws Exception {
        URIish actionURL = new URIish("https://github.com/jenkinsci/multiple-scms-plugin.git");
        RevisionParameterAction target = new RevisionParameterAction("sha1", actionURL);
        URIish remoteURL = new URIish("https://github.com/jenkinsci/git-plugin.git");
        Assert.assertFalse((String)"should return false on different remotes", (boolean)target.canOriginateFrom(this.remotes(remoteURL)));
    }

    @Test
    public void remoteURLSetAndMatches() throws Exception {
        URIish actionURL = new URIish("https://github.com/jenkinsci/git-plugin.git");
        RevisionParameterAction target = new RevisionParameterAction("sha1", actionURL);
        URIish remoteURL = new URIish("https://github.com/jenkinsci/git-plugin.git");
        Assert.assertTrue((String)"should return true on same remotes", (boolean)target.canOriginateFrom(this.remotes(remoteURL)));
    }

    @Test
    public void multipleRemoteURLsSetAndOneMatches() throws Exception {
        URIish actionURL = new URIish("https://github.com/jenkinsci/git-plugin.git");
        RevisionParameterAction target = new RevisionParameterAction("sha1", actionURL);
        URIish remoteURL1 = new URIish("https://github.com/jenkinsci/multiple-scms-plugin.git");
        URIish remoteURL2 = new URIish("https://github.com/jenkinsci/git-plugin.git");
        Assert.assertTrue((String)"should return true when any remote matches", (boolean)target.canOriginateFrom(this.remotes(remoteURL1, remoteURL2)));
    }

    private List<RemoteConfig> remotes(URIish ... remoteURLs) {
        ArrayList<RemoteConfig> result = new ArrayList<RemoteConfig>();
        for (URIish remoteURL : remoteURLs) {
            result.add(this.remote(remoteURL));
        }
        return result;
    }

    private RemoteConfig remote(URIish remoteURL) {
        RemoteConfig result = (RemoteConfig)Mockito.mock(RemoteConfig.class);
        Mockito.when((Object)result.getURIs()).thenReturn(Collections.singletonList(remoteURL));
        return result;
    }
}

