/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser.casc;

import hudson.plugins.git.browser.GitLab;
import hudson.plugins.git.browser.casc.GitLabConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.model.Mapping;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class GitLabConfiguratorTest {
    private final GitLabConfigurator configurator = new GitLabConfigurator();
    private static final ConfigurationContext NULL_CONFIGURATION_CONTEXT = null;

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"gitLab", (Object)this.configurator.getName());
    }

    @Test
    public void testGetTarget() {
        Assert.assertEquals((String)"Wrong target class", (Object)this.configurator.getTarget(), GitLab.class);
    }

    @Test
    public void testCanConfigure() {
        Assert.assertTrue((String)"Can't configure AdvisorGlobalConfiguration", (boolean)this.configurator.canConfigure(GitLab.class));
        Assert.assertFalse((String)"Can configure AdvisorRootConfigurator", (boolean)this.configurator.canConfigure(GitLabConfigurator.class));
    }

    @Test
    public void testGetImplementedAPI() {
        Assert.assertEquals((String)"Wrong implemented API", (Object)this.configurator.getImplementedAPI(), GitLab.class);
    }

    @Test
    public void testGetConfigurators() {
        MatcherAssert.assertThat((Object)this.configurator.getConfigurators(NULL_CONFIGURATION_CONTEXT), (Matcher)Matchers.contains((Object[])new Configurator[]{this.configurator}));
    }

    @Test
    @Deprecated
    public void testDescribe() throws Exception {
        Mapping expectedMapping = new Mapping();
        expectedMapping.put("repoUrl", "http://fake");
        expectedMapping.put("version", "1.1");
        GitLab configuration = new GitLab("http://fake", "1.1");
        Mapping described = this.configurator.describe(configuration, NULL_CONFIGURATION_CONTEXT).asMapping();
        Assert.assertEquals((Object)expectedMapping.getScalarValue("repoUrl"), (Object)described.getScalarValue("repoUrl"));
        Assert.assertEquals((Object)expectedMapping.getScalarValue("version"), (Object)described.getScalarValue("version"));
    }

    @Test
    @Deprecated
    public void testInstance() throws Exception {
        GitLab expectedConfiguration = new GitLab("http://fake", "2.0");
        Mapping mapping = new Mapping();
        mapping.put("repoUrl", "http://fake");
        mapping.put("version", "2.0");
        GitLab instance = this.configurator.instance(mapping, NULL_CONFIGURATION_CONTEXT);
        Assert.assertEquals((Object)expectedConfiguration.getRepoUrl(), (Object)instance.getRepoUrl());
        Assert.assertEquals((Object)String.valueOf(expectedConfiguration.getVersion()), (Object)String.valueOf(instance.getVersion()));
    }

    @Test
    @Deprecated
    public void testInstanceWithEmptyRepo() throws Exception {
        GitLab expectedConfiguration = new GitLab("", "2.0");
        Mapping mapping = new Mapping();
        mapping.put("repoUrl", "");
        mapping.put("version", "2.0");
        GitLab instance = this.configurator.instance(mapping, NULL_CONFIGURATION_CONTEXT);
        Assert.assertEquals((Object)expectedConfiguration.getRepoUrl(), (Object)instance.getRepoUrl());
        Assert.assertEquals((Object)String.valueOf(expectedConfiguration.getVersion()), (Object)String.valueOf(instance.getVersion()));
    }

    @Test
    @Deprecated
    public void testInstanceWithNullRepo() throws Exception {
        GitLab expectedConfiguration = new GitLab(null, "2.0");
        Mapping mapping = new Mapping();
        mapping.put("version", "2.0");
        GitLab instance = this.configurator.instance(mapping, NULL_CONFIGURATION_CONTEXT);
        MatcherAssert.assertThat((Object)instance.getRepoUrl(), (Matcher)Matchers.isEmptyString());
        Assert.assertEquals((Object)String.valueOf(expectedConfiguration.getVersion()), (Object)String.valueOf(instance.getVersion()));
    }

    @Test
    @Deprecated
    public void testInstanceWithEmptyVersion() throws Exception {
        GitLab expectedConfiguration = new GitLab("http://fake", "");
        Mapping mapping = new Mapping();
        mapping.put("repoUrl", "http://fake");
        mapping.put("version", "");
        GitLab instance = this.configurator.instance(mapping, NULL_CONFIGURATION_CONTEXT);
        Assert.assertEquals((Object)expectedConfiguration.getRepoUrl(), (Object)instance.getRepoUrl());
        Assert.assertEquals((Object)String.valueOf(expectedConfiguration.getVersion()), (Object)String.valueOf(instance.getVersion()));
    }

    @Test
    @Deprecated
    public void testInstanceWithNullVersion() throws Exception {
        GitLab expectedConfiguration = new GitLab("http://fake", "");
        Mapping mapping = new Mapping();
        mapping.put("repoUrl", "http://fake");
        GitLab instance = this.configurator.instance(mapping, NULL_CONFIGURATION_CONTEXT);
        Assert.assertEquals((Object)expectedConfiguration.getRepoUrl(), (Object)instance.getRepoUrl());
        Assert.assertEquals((Object)String.valueOf(expectedConfiguration.getVersion()), (Object)String.valueOf(instance.getVersion()));
    }

    @Test
    @Deprecated
    public void testInstanceWithNullMapping() throws Exception {
        GitLab expectedConfiguration = new GitLab("", "");
        Mapping mapping = null;
        GitLab instance = this.configurator.instance(mapping, NULL_CONFIGURATION_CONTEXT);
        Assert.assertEquals((Object)expectedConfiguration.getRepoUrl(), (Object)instance.getRepoUrl());
        Assert.assertEquals((Object)String.valueOf(expectedConfiguration.getVersion()), (Object)String.valueOf(instance.getVersion()));
    }

    @Test
    @Deprecated
    public void testInstanceWithNaNVersion() throws Exception {
        Mapping mapping = new Mapping();
        mapping.put("repoUrl", "http://fake");
        mapping.put("version", "NaN");
        GitLab expectedConfiguration = new GitLab("http://fake", "");
        GitLab instance = this.configurator.instance(mapping, NULL_CONFIGURATION_CONTEXT);
        Assert.assertEquals((Object)expectedConfiguration.getRepoUrl(), (Object)instance.getRepoUrl());
        Assert.assertEquals((Object)String.valueOf(expectedConfiguration.getVersion()), (Object)String.valueOf(instance.getVersion()));
    }
}

