/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.CloneOption;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import java.io.PrintStream;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=Parameterized.class)
public class CloneOptionDepthTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();
    private GitSCM scm;
    private Run<?, ?> build;
    private GitClient git;
    private TaskListener listener;
    private final int configuredDepth;
    private final int usedDepth;

    public CloneOptionDepthTest(int configuredDepth, int usedDepth) {
        this.configuredDepth = configuredDepth;
        this.usedDepth = usedDepth;
    }

    @Parameterized.Parameters(name="depth: configured={0}, used={1}")
    public static Object[][] depthCombinations() {
        return new Object[][]{{0, 1}, {1, 1}, {2, 2}};
    }

    @Before
    public void mockDependencies() throws Exception {
        this.scm = (GitSCM)Mockito.mock(GitSCM.class);
        this.build = (Run)Mockito.mock(Run.class);
        this.git = (GitClient)Mockito.mock(GitClient.class);
        this.listener = (TaskListener)Mockito.mock(TaskListener.class);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        buildData.lastBuild = (Build)Mockito.mock(Build.class);
        Mockito.when((Object)this.build.getEnvironment(this.listener)).thenReturn((Object)((EnvVars)Mockito.mock(EnvVars.class)));
        Mockito.when((Object)this.scm.getBuildData(this.build)).thenReturn((Object)buildData);
    }

    @Test
    public void decorateCloneCommandShouldUseValidShallowDepth() throws Exception {
        CloneCommand cloneCommand = (CloneCommand)Mockito.mock(CloneCommand.class, (Answer)Mockito.RETURNS_SELF);
        PrintStream logger = (PrintStream)Mockito.mock(PrintStream.class);
        Mockito.when((Object)this.listener.getLogger()).thenReturn((Object)logger);
        CloneOption cloneOption = new CloneOption(true, false, null, null);
        cloneOption.setDepth(Integer.valueOf(this.configuredDepth));
        cloneOption.decorateCloneCommand(this.scm, this.build, this.git, this.listener, cloneCommand);
        ((CloneCommand)Mockito.verify((Object)cloneCommand)).shallow(true);
        ((CloneCommand)Mockito.verify((Object)cloneCommand)).depth(Integer.valueOf(this.usedDepth));
        ((PrintStream)Mockito.verify((Object)logger)).println("Using shallow clone with depth " + this.usedDepth);
    }

    @Test
    @Deprecated
    public void decorateFetchCommandShouldUseValidShallowDepth() throws Exception {
        FetchCommand fetchCommand = (FetchCommand)Mockito.mock(FetchCommand.class, (Answer)Mockito.RETURNS_SELF);
        PrintStream logger = (PrintStream)Mockito.mock(PrintStream.class);
        Mockito.when((Object)this.listener.getLogger()).thenReturn((Object)logger);
        CloneOption cloneOption = new CloneOption(true, false, null, null);
        cloneOption.setDepth(Integer.valueOf(this.configuredDepth));
        cloneOption.decorateFetchCommand(this.scm, this.git, this.listener, fetchCommand);
        ((FetchCommand)Mockito.verify((Object)fetchCommand)).shallow(true);
        ((FetchCommand)Mockito.verify((Object)fetchCommand)).depth(Integer.valueOf(this.usedDepth));
        ((PrintStream)Mockito.verify((Object)logger)).println("Using shallow fetch with depth " + this.usedDepth);
    }
}

