/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionTest;
import hudson.plugins.git.extensions.impl.PreBuildMerge;
import hudson.plugins.git.util.BuildData;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.junit.Assert;
import org.junit.Test;

public class PreBuildMergeTest
extends GitSCMExtensionTest {
    private FreeStyleProject project;
    private TestGitRepo repo;
    private String MASTER_FILE = "commitFileBase";

    @Override
    public void before() throws Exception {
        this.repo = new TestGitRepo("repo", this.tmp.newFolder(), this.listener);
        this.project = this.setupBasicProject(this.repo);
        this.repo.commit(this.MASTER_FILE, this.repo.johnDoe, "Initial Commit");
        this.repo.git.branch("integration");
    }

    @Test
    public void testBasicPreMerge() throws Exception {
        FreeStyleBuild firstBuild = this.build(this.project, Result.SUCCESS);
    }

    @Test
    public void testFailedMerge() throws Exception {
        FreeStyleBuild firstBuild = this.build(this.project, Result.SUCCESS);
        Assert.assertEquals(GitSCM.class, this.project.getScm().getClass());
        GitSCM gitSCM = (GitSCM)this.project.getScm();
        BuildData buildData = gitSCM.getBuildData((Run)firstBuild);
        Assert.assertNotNull((String)"Build data not found", (Object)buildData);
        Assert.assertEquals((long)firstBuild.getNumber(), (long)buildData.lastBuild.getBuildNumber());
        Revision firstMarked = buildData.lastBuild.getMarked();
        Revision firstRevision = buildData.lastBuild.getRevision();
        Assert.assertNotNull((Object)firstMarked);
        Assert.assertNotNull((Object)firstRevision);
        this.repo.git.deleteBranch("integration");
        this.repo.git.checkoutBranch("integration", "master");
        this.repo.commit(this.MASTER_FILE, "new content on integration branch", this.repo.johnDoe, this.repo.johnDoe, "Commit which should fail!");
        this.repo.git.checkout().ref("master").execute();
        Assert.assertFalse((String)"SCM polling should not detect any more changes after build", (boolean)this.project.poll(this.listener).hasChanges());
        String conflictSha1 = this.repo.commit(this.MASTER_FILE, "new content - expect a merge conflict!", this.repo.johnDoe, this.repo.johnDoe, "Commit which should fail!");
        Assert.assertTrue((String)"SCM polling should detect changes", (boolean)this.project.poll(this.listener).hasChanges());
        FreeStyleBuild secondBuild = this.build(this.project, Result.FAILURE);
        Assert.assertEquals((long)secondBuild.getNumber(), (long)gitSCM.getBuildData((Run)secondBuild).lastBuild.getBuildNumber());
        Assert.assertEquals((Object)conflictSha1, (Object)gitSCM.getBuildData((Run)secondBuild).lastBuild.getMarked().getSha1String());
        Assert.assertEquals((Object)conflictSha1, (Object)gitSCM.getBuildData((Run)secondBuild).lastBuild.getRevision().getSha1String());
        Assert.assertEquals((long)firstBuild.getNumber(), (long)gitSCM.getBuildData((Run)firstBuild).lastBuild.getBuildNumber());
        Assert.assertEquals((Object)firstMarked, (Object)gitSCM.getBuildData((Run)firstBuild).lastBuild.getMarked());
        Assert.assertEquals((Object)firstRevision, (Object)gitSCM.getBuildData((Run)firstBuild).lastBuild.getRevision());
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(PreBuildMerge.class).usingGetClass().verify();
    }

    @Override
    protected GitSCMExtension getExtension() {
        return new PreBuildMerge(new UserMergeOptions("origin", "integration", "default", MergeCommand.GitPluginFastForwardMode.FF));
    }
}

