/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.EnvVars;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.SubmoduleOption;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildData;
import java.io.PrintStream;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.SubmoduleUpdateCommand;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@RunWith(value=Parameterized.class)
public class SubmoduleOptionDepthTest {
    private GitSCM scm;
    private Run<?, ?> build;
    private GitClient git;
    private TaskListener listener;
    private final int configuredDepth;
    private final int usedDepth;

    public SubmoduleOptionDepthTest(int configuredDepth, int usedDepth) {
        this.configuredDepth = configuredDepth;
        this.usedDepth = usedDepth;
    }

    @Parameterized.Parameters(name="depth: configured={0}, used={1}")
    public static Object[][] depthCombinations() {
        return new Object[][]{{0, 1}, {1, 1}, {2, 2}};
    }

    @Before
    public void mockDependencies() throws Exception {
        this.scm = (GitSCM)Mockito.mock(GitSCM.class);
        this.build = (Run)Mockito.mock(Run.class);
        this.git = (GitClient)Mockito.mock(GitClient.class);
        this.listener = (TaskListener)Mockito.mock(TaskListener.class);
        BuildData buildData = (BuildData)Mockito.mock(BuildData.class);
        buildData.lastBuild = (Build)Mockito.mock(Build.class);
        Mockito.when((Object)this.build.getEnvironment(this.listener)).thenReturn((Object)((EnvVars)Mockito.mock(EnvVars.class)));
        Mockito.when((Object)this.scm.getBuildData(this.build)).thenReturn((Object)buildData);
    }

    @Test
    public void submoduleUpdateShouldUseValidShallowDepth() throws Exception {
        SubmoduleUpdateCommand submoduleUpdate = (SubmoduleUpdateCommand)Mockito.mock(SubmoduleUpdateCommand.class, (Answer)Mockito.RETURNS_SELF);
        Mockito.when((Object)this.git.hasGitModules()).thenReturn((Object)true);
        Mockito.when((Object)this.git.submoduleUpdate()).thenReturn((Object)submoduleUpdate);
        PrintStream logger = (PrintStream)Mockito.mock(PrintStream.class);
        Mockito.when((Object)this.listener.getLogger()).thenReturn((Object)logger);
        SubmoduleOption submoduleOption = new SubmoduleOption(false, false, false, null, null, false);
        submoduleOption.setShallow(true);
        submoduleOption.setDepth(Integer.valueOf(this.configuredDepth));
        submoduleOption.onCheckoutCompleted(this.scm, this.build, this.git, this.listener);
        ((SubmoduleUpdateCommand)Mockito.verify((Object)submoduleUpdate)).shallow(true);
        ((SubmoduleUpdateCommand)Mockito.verify((Object)submoduleUpdate)).depth(Integer.valueOf(this.usedDepth));
        ((PrintStream)Mockito.verify((Object)logger)).println("Using shallow submodule update with depth " + this.usedDepth);
    }
}

