/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git.traits;

import hudson.model.Action;
import hudson.model.Run;
import java.util.Collections;
import java.util.Random;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.libs.GlobalLibraries;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.SCMSourceRetriever;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.RestartableJenkinsRule;

public class MultibranchProjectTraitsTest {
    @Rule
    public RestartableJenkinsRule story = new RestartableJenkinsRule();
    @Rule
    public GitSampleRepoRule sharedLibrarySampleRepo = new GitSampleRepoRule();
    private Random random = new Random();

    @Before
    public void setUpTestRepositories() throws Exception {
        this.sharedLibrarySampleRepo.init();
        this.sharedLibrarySampleRepo.write("vars/book.groovy", "def call() {echo 'Greetings from the library'}");
        this.sharedLibrarySampleRepo.git("checkout", "-b", "libraryBranch");
        this.sharedLibrarySampleRepo.git("add", "vars");
        this.sharedLibrarySampleRepo.git("commit", "--message=Shared library created in libraryBranch");
    }

    @Test
    public void basicSharedLibrarySymbolsTest() throws Exception {
        this.story.then(r -> {
            GlobalLibraries.get().setLibraries(Collections.singletonList(new LibraryConfiguration("thelibrary", (LibraryRetriever)new SCMSourceRetriever((SCMSource)new GitSCMSource(this.sharedLibrarySampleRepo.toString())))));
            WorkflowJob job = (WorkflowJob)this.story.j.jenkins.createProject(WorkflowJob.class, "test-pipeline-job");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition("library 'thelibrary@libraryBranch'\nnode() {\n  book()\n  checkout scmGit(\n" + this.randomBrowserSymbolName() + "    userRemoteConfigs: [[url: $/" + this.sharedLibrarySampleRepo + "/$]]\n  )}", true));
            WorkflowRun run = (WorkflowRun)this.story.j.waitForCompletion((Run)((WorkflowRun)job.scheduleBuild2(0, new Action[0]).waitForStart()));
            this.story.j.waitForCompletion((Run)run);
            this.story.j.waitForMessage("Finished: SUCCESS", (Run)run);
            this.story.j.assertLogContains("Greetings from the library", (Run)run);
        });
    }

    @Test
    public void basicSharedLibraryClassTest() throws Exception {
        this.story.then(r -> {
            GlobalLibraries.get().setLibraries(Collections.singletonList(new LibraryConfiguration("thelibrary", (LibraryRetriever)new SCMSourceRetriever((SCMSource)new GitSCMSource(this.sharedLibrarySampleRepo.toString())))));
            WorkflowJob job = (WorkflowJob)this.story.j.jenkins.createProject(WorkflowJob.class, "test-pipeline-job");
            job.setDefinition((FlowDefinition)new CpsFlowDefinition("library 'thelibrary@libraryBranch'\nnode {\n  book()\n  checkout(\n    [$class: 'GitSCM', \n" + this.randomBrowserClass() + "    userRemoteConfigs: [[url: $/" + this.sharedLibrarySampleRepo + "/$]]]\n  )}", true));
            WorkflowRun run = (WorkflowRun)this.story.j.waitForCompletion((Run)((WorkflowRun)job.scheduleBuild2(0, new Action[0]).waitForStart()));
            this.story.j.waitForCompletion((Run)run);
            this.story.j.waitForMessage("Finished: SUCCESS", (Run)run);
            this.story.j.assertLogContains("Greetings from the library", (Run)run);
        });
    }

    private String randomBrowserSymbolName() {
        String[] browsersBySymbolName = new String[]{"    browser: bitbucket('https://markewaite@bitbucket.org/markewaite/git-plugin'),\n", "    browser: cgit('https://git.zx2c4.com/cgit'),\n", "    browser: fisheye('https://fisheye.apache.org/browse/ant-git'),\n", "    browser: gitblit(repoUrl: 'https://github.com/MarkEWaite/git-client-plugin', projectName: 'git-plugin-project-name-value'),\n", "    browser: gitLab(repoUrl: 'https://gitlab.com/MarkEWaite/git-client-plugin', version: '12.10.1'),\n", "    browser: gitList('http://gitlist.org/'),\n", "    browser: gitWeb('https://git.ti.com/gitweb'),\n", "    browser: github('https://github.com/jenkinsci/git-plugin'),\n", "    browser: gitiles('https://gerrit.googlesource.com/gitiles/'),\n", "    browser: gogs('https://try.gogs.io/MarkEWaite/git-plugin'),\n", "    browser: kiln('https://kiln.example.com/MarkEWaite/git-plugin'),\n", "    browser: teamFoundation('https://markwaite.visualstudio.com/DefaultCollection/git-plugin/_git/git-plugin'),\n", "    browser: phabricator(repo: 'source/tool-spacemedia', repoUrl: 'https://phabricator.wikimedia.org/source/tool-spacemedia/'),\n", "    browser: redmine('https://www.redmine.org/projects/redmine/repository'),\n", "    browser: rhodeCode('https://code.rhodecode.com/rhodecode-enterprise-ce'),\n", "    browser: viewgit(repoUrl: 'https://repo.or.cz/viewgit.git', projectName: 'viewgit-project-name-value'),\n"};
        String browser = browsersBySymbolName[this.random.nextInt(browsersBySymbolName.length)];
        return browser;
    }

    private String randomBrowserClass() {
        String[] browsersByClass = new String[]{"    browser: [$class: 'AssemblaWeb', repoUrl: 'https://app.assembla.com/spaces/git-plugin/git/source'],\n", "    browser: [$class: 'BitbucketWeb', repoUrl: 'https://markewaite@bitbucket.org/markewaite/git-plugin'],\n", "    browser: [$class: 'CGit', repoUrl: 'https://git.zx2c4.com/cgit'],\n", "    browser: [$class: 'FisheyeGitRepositoryBrowser', repoUrl: 'https://fisheye.apache.org/browse/ant-git'],\n", "    browser: [$class: 'GitBlitRepositoryBrowser', repoUrl: 'https://github.com/MarkEWaite/git-plugin', projectName: 'git-plugin-project-name-value'],\n", "    browser: [$class: 'GitLab', repoUrl: 'https://gitlab.com/MarkEWaite/git-client-plugin', version: '12.10.1'],\n", "    browser: [$class: 'GitList', repoUrl: 'http://gitlist.org/'],\n", "    browser: [$class: 'GitWeb', repoUrl: 'https://git.ti.com/gitweb'],\n", "    browser: [$class: 'GithubWeb', repoUrl: 'https://github.com/jenkinsci/git-plugin'],\n", "    browser: [$class: 'Gitiles', repoUrl: 'https://gerrit.googlesource.com/gitiles/'],\n", "    browser: [$class: 'GogsGit', repoUrl: 'https://try.gogs.io/MarkEWaite/git-plugin'],\n", "    browser: [$class: 'KilnGit', repoUrl: 'https://kiln.example.com/MarkEWaite/git-plugin'],\n", "    browser: [$class: 'Phabricator', repo: 'source/tool-spacemedia', repoUrl: 'https://phabricator.wikimedia.org/source/tool-spacemedia/'],\n", "    browser: [$class: 'RedmineWeb', repoUrl: 'https://www.redmine.org/projects/redmine/repository'],\n", "    browser: [$class: 'Stash', repoUrl: 'https://markewaite@bitbucket.org/markewaite/git-plugin'],\n", "    browser: [$class: 'TFS2013GitRepositoryBrowser', repoUrl: 'https://markwaite.visualstudio.com/DefaultCollection/git-plugin/_git/git-plugin'],\n", "    browser: [$class: 'RhodeCode', repoUrl: 'https://code.rhodecode.com/rhodecode-enterprise-ce'],\n", "    browser: [$class: 'ViewGitWeb', repoUrl: 'https://git.ti.com/gitweb', projectName: 'viewgitweb-project-name-value'],\n"};
        String browser = browsersByClass[this.random.nextInt(browsersByClass.length)];
        return browser;
    }
}

