/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.extensions.impl.CloneOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitRefSCMHead;
import jenkins.plugins.git.GitSCMSourceDefaults;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.TagSCMHead;
import jenkins.scm.api.trait.SCMBuilder;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RefSpec;

public class GitSCMBuilder<B extends GitSCMBuilder<B>>
extends SCMBuilder<B, GitSCM> {
    @CheckForNull
    private GitRepositoryBrowser browser;
    @NonNull
    private final List<GitSCMExtension> extensions = new ArrayList<GitSCMExtension>();
    @CheckForNull
    private String credentialsId;
    @CheckForNull
    private String gitTool;
    @NonNull
    private List<String> refSpecs = new ArrayList<String>();
    @NonNull
    private String remoteName = "origin";
    @NonNull
    private String remote;
    @NonNull
    private final Map<String, AdditionalRemote> additionalRemotes = new TreeMap<String, AdditionalRemote>();

    public GitSCMBuilder(@NonNull SCMHead head, @CheckForNull SCMRevision revision, @NonNull String remote, @CheckForNull String credentialsId) {
        super(GitSCM.class, head, revision);
        this.remote = remote;
        this.credentialsId = credentialsId;
    }

    @CheckForNull
    public final GitRepositoryBrowser browser() {
        return this.browser;
    }

    @CheckForNull
    public final String credentialsId() {
        return this.credentialsId;
    }

    @NonNull
    public final List<GitSCMExtension> extensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    @CheckForNull
    public final String gitTool() {
        return this.gitTool;
    }

    @NonNull
    public final List<String> refSpecs() {
        if (this.refSpecs.isEmpty()) {
            return Collections.singletonList("+refs/heads/*:refs/remotes/@{remote}/*");
        }
        return Collections.unmodifiableList(this.refSpecs);
    }

    @NonNull
    public final String remote() {
        return this.remote;
    }

    @NonNull
    public final String remoteName() {
        return this.remoteName;
    }

    @NonNull
    public final Set<String> additionalRemoteNames() {
        return Collections.unmodifiableSet(this.additionalRemotes.keySet());
    }

    @CheckForNull
    public final String additionalRemote(String remoteName) {
        AdditionalRemote additionalRemote = this.additionalRemotes.get(remoteName);
        return additionalRemote == null ? null : additionalRemote.remote();
    }

    @CheckForNull
    public final List<String> additionalRemoteRefSpecs(String remoteName) {
        AdditionalRemote additionalRemote = this.additionalRemotes.get(remoteName);
        return additionalRemote == null ? null : additionalRemote.refSpecs();
    }

    @NonNull
    public final B withBrowser(@CheckForNull GitRepositoryBrowser browser) {
        this.browser = browser;
        return (B)((Object)this);
    }

    @NonNull
    public final B withCredentials(@CheckForNull String credentialsId) {
        this.credentialsId = credentialsId;
        return (B)((Object)this);
    }

    @NonNull
    public final B withExtension(@CheckForNull GitSCMExtension extension) {
        if (extension != null) {
            this.extensions.removeIf(gitSCMExtension -> ((Object)((Object)extension)).getClass().equals(((Object)gitSCMExtension).getClass()));
            this.extensions.add(extension);
        }
        return (B)((Object)this);
    }

    @NonNull
    public final B withExtensions(GitSCMExtension ... extensions) {
        return this.withExtensions(Arrays.asList(extensions));
    }

    @NonNull
    public final B withExtensions(@NonNull List<GitSCMExtension> extensions) {
        for (GitSCMExtension extension : extensions) {
            this.withExtension(extension);
        }
        return (B)((Object)this);
    }

    @NonNull
    public final B withGitTool(@CheckForNull String gitTool) {
        this.gitTool = gitTool;
        return (B)((Object)this);
    }

    @NonNull
    public final B withRefSpec(@NonNull String refSpec) {
        this.refSpecs.add(refSpec);
        return (B)((Object)this);
    }

    @NonNull
    public final B withRefSpecs(@NonNull List<String> refSpecs) {
        this.refSpecs.addAll(refSpecs);
        return (B)((Object)this);
    }

    @NonNull
    public final B withoutRefSpecs() {
        this.refSpecs.clear();
        return (B)((Object)this);
    }

    @NonNull
    public final B withRemote(@NonNull String remote) {
        this.remote = remote;
        return (B)((Object)this);
    }

    @NonNull
    public final B withRemoteName(@CheckForNull String remoteName) {
        this.remoteName = StringUtils.defaultIfBlank((String)remoteName, (String)"origin");
        return (B)((Object)this);
    }

    @NonNull
    public final B withAdditionalRemote(@NonNull String remoteName, @NonNull String remote, String ... refSpecs) {
        return this.withAdditionalRemote(remoteName, remote, Arrays.asList(refSpecs));
    }

    @NonNull
    public final B withAdditionalRemote(@NonNull String remoteName, @NonNull String remote, List<String> refSpecs) {
        this.additionalRemotes.put(remoteName, new AdditionalRemote(remoteName, remote, refSpecs));
        return (B)((Object)this);
    }

    @NonNull
    public final List<RefSpec> asRefSpecs() {
        LinkedHashSet<String> refSpecs = new LinkedHashSet<String>(Math.max(this.refSpecs.size(), 1));
        for (String template : this.refSpecs()) {
            refSpecs.add(template.replaceAll(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER, this.remoteName()));
        }
        ArrayList<RefSpec> result = new ArrayList<RefSpec>(refSpecs.size());
        for (String refSpec : refSpecs) {
            result.add(new RefSpec(refSpec));
        }
        return result;
    }

    @NonNull
    public final List<UserRemoteConfig> asRemoteConfigs() {
        ArrayList<UserRemoteConfig> result = new ArrayList<UserRemoteConfig>(1 + this.additionalRemotes.size());
        result.add(new UserRemoteConfig(this.remote(), this.remoteName(), this.joinRefSpecs(this.asRefSpecs()), this.credentialsId()));
        for (AdditionalRemote r : this.additionalRemotes.values()) {
            result.add(new UserRemoteConfig(r.remote(), r.remoteName(), this.joinRefSpecs(r.asRefSpecs()), this.credentialsId()));
        }
        return result;
    }

    private String joinRefSpecs(List<RefSpec> refSpecs) {
        if (refSpecs.isEmpty()) {
            return "";
        }
        if (refSpecs.size() == 1) {
            return refSpecs.get(0).toString();
        }
        StringBuilder result = new StringBuilder(refSpecs.size() * 50);
        boolean first = true;
        for (RefSpec r : refSpecs) {
            if (first) {
                first = false;
            } else {
                result.append(' ');
            }
            result.append(r.toString());
        }
        return result.toString();
    }

    @NonNull
    public GitSCM build() {
        SCMHead scmHead;
        SCMRevision revision;
        ArrayList<GitSCMExtension> extensions = new ArrayList<GitSCMExtension>(this.extensions());
        boolean foundClone = false;
        for (GitSCMExtension e : extensions) {
            if (!(e instanceof CloneOption)) continue;
            foundClone = true;
            break;
        }
        if (!foundClone) {
            extensions.add(new GitSCMSourceDefaults(this.head() instanceof TagSCMHead));
        }
        if ((revision = this.revision()) instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            extensions.removeIf(gitSCMExtension -> gitSCMExtension instanceof BuildChooserSetting);
            extensions.add(new BuildChooserSetting(new AbstractGitSCMSource.SpecificRevisionBuildChooser((AbstractGitSCMSource.SCMRevisionImpl)revision)));
        }
        if ((scmHead = this.head()) instanceof GitRefSCMHead) {
            GitRefSCMHead gitHead = (GitRefSCMHead)scmHead;
            this.withRefSpec(gitHead.getRef());
        }
        try {
            return new GitSCM(this.asRemoteConfigs(), Collections.singletonList(new BranchSpec(this.head().getName())), this.browser(), this.gitTool(), extensions);
        }
        catch (GitException x) {
            throw new IllegalStateException(x);
        }
    }

    private static final class AdditionalRemote {
        @NonNull
        private final String name;
        @NonNull
        private final String url;
        @NonNull
        private final List<String> refSpecs;

        public AdditionalRemote(@NonNull String name, @NonNull String url, @NonNull List<String> refSpecs) {
            this.name = name;
            this.url = url;
            this.refSpecs = new ArrayList<String>(refSpecs.isEmpty() ? Collections.singletonList("+refs/heads/*:refs/remotes/@{remote}/*") : refSpecs);
        }

        public String remoteName() {
            return this.name;
        }

        public String remote() {
            return this.url;
        }

        public List<String> refSpecs() {
            return Collections.unmodifiableList(this.refSpecs);
        }

        @NonNull
        public final List<RefSpec> asRefSpecs() {
            LinkedHashSet<String> refSpecs = new LinkedHashSet<String>(Math.max(this.refSpecs.size(), 1));
            for (String template : this.refSpecs()) {
                refSpecs.add(template.replaceAll(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER, this.remoteName()));
            }
            ArrayList<RefSpec> result = new ArrayList<RefSpec>(refSpecs.size());
            for (String refSpec : refSpecs) {
                result.add(new RefSpec(refSpec));
            }
            return result;
        }
    }
}

