/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.transport.RemoteConfig;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;

public class GitSCMSourceDefaults
extends GitSCMExtension {
    private final boolean includeTags;

    public GitSCMSourceDefaults(boolean includeTags) {
        this.includeTags = includeTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GitSCMSourceDefaults that = (GitSCMSourceDefaults)((Object)o);
        return this.includeTags == that.includeTags;
    }

    public int hashCode() {
        return this.includeTags ? 1 : 0;
    }

    public String toString() {
        return "GitSCMSourceDefaults{includeTags=" + this.includeTags + "}";
    }

    @Override
    public void decorateCloneCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, CloneCommand cmd) throws IOException, InterruptedException, GitException {
        listener.getLogger().printf("Cloning with configured refspecs honoured and %s tags%n", this.includeTags ? "with" : "without");
        RemoteConfig rc = scm.getRepositories().get(0);
        List refspecs = rc.getFetchRefSpecs();
        cmd.refspecs(refspecs);
        cmd.tags(this.includeTags);
    }

    @Override
    @Deprecated
    public void decorateFetchCommand(GitSCM scm, GitClient git, TaskListener listener, FetchCommand cmd) throws IOException, InterruptedException, GitException {
        listener.getLogger().printf("Fetching %s tags%n", this.includeTags ? "with" : "without");
        cmd.tags(this.includeTags);
    }
}

