/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.security.Permission;
import hudson.util.ListBoxModel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.github_branch_source.ApiRateLimitChecker;
import org.jenkinsci.plugins.github_branch_source.Endpoint;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class GitHubConfiguration
extends GlobalConfiguration {
    private List<Endpoint> endpoints;
    private ApiRateLimitChecker apiRateLimitChecker;

    public static GitHubConfiguration get() {
        return (GitHubConfiguration)((Object)GlobalConfiguration.all().get(GitHubConfiguration.class));
    }

    public GitHubConfiguration() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return true;
    }

    @NonNull
    public synchronized List<Endpoint> getEndpoints() {
        return this.endpoints == null ? Collections.emptyList() : Collections.unmodifiableList(this.endpoints);
    }

    @NonNull
    public synchronized ApiRateLimitChecker getApiRateLimitChecker() {
        if (this.apiRateLimitChecker == null) {
            return ApiRateLimitChecker.ThrottleForNormalize;
        }
        return this.apiRateLimitChecker;
    }

    public synchronized void setApiRateLimitChecker(@CheckForNull ApiRateLimitChecker apiRateLimitChecker) {
        this.apiRateLimitChecker = apiRateLimitChecker;
        this.save();
    }

    @CheckForNull
    public static String normalizeApiUri(@CheckForNull String apiUri) {
        if (apiUri == null) {
            return null;
        }
        try {
            URI uri = new URI(apiUri).normalize();
            String scheme = uri.getScheme();
            if ("http".equals(scheme) || "https".equals(scheme)) {
                String host = uri.getHost() == null ? null : uri.getHost().toLowerCase(Locale.ENGLISH);
                int port = uri.getPort();
                if ("http".equals(scheme) && port == 80) {
                    port = -1;
                } else if ("https".equals(scheme) && port == 443) {
                    port = -1;
                }
                apiUri = new URI(scheme, uri.getUserInfo(), host, port, uri.getPath(), uri.getQuery(), uri.getFragment()).toASCIIString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return apiUri.replaceAll("/$", "");
    }

    public synchronized void setEndpoints(@CheckForNull List<Endpoint> endpoints) {
        endpoints = new ArrayList(endpoints == null ? Collections.emptyList() : endpoints);
        HashSet<String> apiUris = new HashSet<String>();
        Iterator<Endpoint> iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            Endpoint endpoint = iterator.next();
            if (StringUtils.isBlank((String)endpoint.getApiUri()) || apiUris.contains(endpoint.getApiUri())) {
                iterator.remove();
            }
            apiUris.add(endpoint.getApiUri());
        }
        this.endpoints = endpoints;
        this.save();
    }

    public synchronized boolean addEndpoint(@NonNull Endpoint endpoint) {
        if (StringUtils.isBlank((String)endpoint.getApiUri())) {
            return false;
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>(this.getEndpoints());
        for (Endpoint ep : endpoints) {
            if (!StringUtils.equals((String)ep.getApiUri(), (String)endpoint.getApiUri())) continue;
            return false;
        }
        endpoints.add(endpoint);
        this.setEndpoints(endpoints);
        return true;
    }

    public synchronized void updateEndpoint(@NonNull Endpoint endpoint) {
        if (StringUtils.isBlank((String)endpoint.getApiUri())) {
            return;
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>(this.getEndpoints());
        boolean found = false;
        for (int i = 0; i < endpoints.size(); ++i) {
            Endpoint ep = (Endpoint)((Object)endpoints.get(i));
            if (!StringUtils.equals((String)ep.getApiUri(), (String)endpoint.getApiUri())) continue;
            endpoints.set(i, endpoint);
            found = true;
            break;
        }
        if (!found) {
            endpoints.add(endpoint);
        }
        this.setEndpoints(endpoints);
    }

    public boolean removeEndpoint(@NonNull Endpoint endpoint) {
        return this.removeEndpoint(endpoint.getApiUri());
    }

    public synchronized boolean removeEndpoint(@CheckForNull String apiUri) {
        apiUri = GitHubConfiguration.normalizeApiUri(apiUri);
        boolean modified = false;
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>(this.getEndpoints());
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            if (!StringUtils.equals((String)apiUri, (String)((Endpoint)((Object)iterator.next())).getApiUri())) continue;
            iterator.remove();
            modified = true;
        }
        this.setEndpoints(endpoints);
        return modified;
    }

    @CheckForNull
    public synchronized Endpoint findEndpoint(@CheckForNull String apiUri) {
        apiUri = GitHubConfiguration.normalizeApiUri(apiUri);
        for (Endpoint endpoint : this.getEndpoints()) {
            if (!StringUtils.equals((String)apiUri, (String)endpoint.getApiUri())) continue;
            return endpoint;
        }
        return null;
    }

    public ListBoxModel doFillApiRateLimitCheckerItems() {
        ListBoxModel items = new ListBoxModel();
        for (ApiRateLimitChecker mode : ApiRateLimitChecker.values()) {
            items.add(mode.getDisplayName(), mode.name());
        }
        return items;
    }

    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return Jenkins.MANAGE;
    }
}

