/*
 * Decompiled with CFR 0.152.
 */
package javaposse.jobdsl.plugin;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Logger;
import javaposse.jobdsl.plugin.DescriptorImpl;
import javaposse.jobdsl.plugin.SeedReference;
import javaposse.jobdsl.plugin.SeedReferenceDigestPredicate;
import jenkins.YesNoMaybe;
import jenkins.model.Jenkins;

@Extension(dynamicLoadable=YesNoMaybe.YES)
public class MonitorTemplateJobs
extends SaveableListener {
    private static final Logger LOGGER = Logger.getLogger(MonitorTemplateJobs.class.getName());

    public void onChange(Saveable saveable, XmlFile file) {
        String digest;
        LOGGER.finest("onChange");
        if (!AbstractProject.class.isAssignableFrom(saveable.getClass())) {
            LOGGER.finest(String.format("%s is not a Project", saveable.getClass()));
            return;
        }
        AbstractItem project = (AbstractItem)saveable;
        String possibleTemplateName = project.getName();
        DescriptorImpl descriptor = (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
        Collection seedJobReferences = descriptor.getTemplateJobMap().get((Object)possibleTemplateName);
        if (seedJobReferences.isEmpty()) {
            return;
        }
        try {
            digest = Util.getDigestOf((InputStream)new FileInputStream(project.getConfigFile().getFile()));
        }
        catch (IOException e) {
            LOGGER.warning(String.format("Unable to read template %s, which means we wouldn't be able to run seed anyways", possibleTemplateName));
            return;
        }
        Collection changed = Collections2.filter((Collection)Collections2.transform((Collection)Collections2.filter((Collection)seedJobReferences, (Predicate)new SeedReferenceDigestPredicate(digest)), (Function)new LookupProjectFunction()), (Predicate)Predicates.notNull());
        for (BuildableItem seedProject : changed) {
            seedProject.scheduleBuild(30, (Cause)new TemplateTriggerCause());
        }
    }

    private static class LookupProjectFunction
    implements Function<SeedReference, BuildableItem> {
        private LookupProjectFunction() {
        }

        public BuildableItem apply(SeedReference input) {
            return (BuildableItem)Jenkins.get().getItem(input.getSeedJobName());
        }
    }

    public static class TemplateTriggerCause
    extends Cause {
        TemplateTriggerCause() {
        }

        public String getShortDescription() {
            return "Template has changed";
        }

        public boolean equals(Object o) {
            return o instanceof TemplateTriggerCause;
        }

        public int hashCode() {
            return 3;
        }
    }
}

