/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Fingerprint;
import hudson.model.InvisibleAction;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Fingerprinter;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.Helper;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.Messages;
import hudson.tasks.test.TestObject;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AggregatedTestResultPublisher
extends Recorder {
    public final String jobs;
    public final boolean includeFailedBuilds;

    public AggregatedTestResultPublisher(String jobs) {
        this(jobs, false);
    }

    public AggregatedTestResultPublisher(String jobs, boolean includeFailedBuilds) {
        this.jobs = Util.fixEmptyAndTrim((String)jobs);
        this.includeFailedBuilds = includeFailedBuilds;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        build.addAction((Action)new TestResultAction(this.jobs, this.includeFailedBuilds, build));
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singleton(new TestResultProjectAction(project));
    }

    @Restricted(value={NoExternalUse.class})
    public static final class TestResultProjectAction
    extends InvisibleAction {
        public final AbstractProject<?, ?> project;

        private TestResultProjectAction(AbstractProject<?, ?> project) {
            this.project = project;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.AggregatedTestResultPublisher_DisplayName();
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            for (String name : Util.tokenize((String)Util.fixNull((String)value), (String)",")) {
                name = name.trim();
                if (Helper.getActiveInstance().getItem(name, (Item)project) != null) continue;
                AbstractProject nearest = AbstractProject.findNearest((String)name);
                return FormValidation.error((String)hudson.tasks.Messages.BuildTrigger_NoSuchProject((Object)name, (Object)(nearest != null ? nearest.getName() : null)));
            }
            return FormValidation.ok();
        }

        public AggregatedTestResultPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData == null) {
                throw new AssertionError((Object)"Null parameters to Descriptor#newInstance");
            }
            JSONObject s = formData.getJSONObject("specify");
            if (s.isNullObject()) {
                return new AggregatedTestResultPublisher(null, req != null && req.getParameter("includeFailedBuilds") != null);
            }
            return new AggregatedTestResultPublisher(s.getString("jobs"), req != null && req.getParameter("includeFailedBuilds") != null);
        }

        public AutoCompletionCandidates doAutoCompleteJobs(@QueryParameter String value, @AncestorInPath Item self, @AncestorInPath ItemGroup container) {
            return AutoCompletionCandidates.ofJobNames(Job.class, (String)value, (Item)self, (ItemGroup)container);
        }
    }

    public static final class TestResultAction
    extends AbstractTestResultAction {
        @CheckForNull
        private final String jobs;
        private final boolean includeFailedBuilds;
        private transient long lastUpdated = 0L;
        private static long lastChanged = 0L;
        private transient int failCount;
        private transient int totalCount;
        private transient List<AbstractTestResultAction> individuals;
        private transient List<AbstractProject> didntRun;
        private transient List<AbstractProject> noFingerprints;

        public TestResultAction(String jobs, boolean includeFailedBuilds, AbstractBuild<?, ?> owner) {
            super(owner);
            this.includeFailedBuilds = includeFailedBuilds;
            if (jobs == null) {
                StringBuilder buf = new StringBuilder();
                for (AbstractProject p : this.getProject().getTransitiveDownstreamProjects()) {
                    if (buf.length() > 0) {
                        buf.append(',');
                    }
                    buf.append(p.getFullName());
                }
                jobs = buf.toString();
            }
            this.jobs = jobs;
        }

        public Collection<AbstractProject> getJobs() {
            ArrayList<AbstractProject> r = new ArrayList<AbstractProject>();
            if (this.jobs != null) {
                for (String job : Util.tokenize((String)this.jobs, (String)",")) {
                    try {
                        AbstractProject j = (AbstractProject)Helper.getActiveInstance().getItemByFullName(job.trim(), AbstractProject.class);
                        if (j == null) continue;
                        r.add(j);
                    }
                    catch (AccessDeniedException accessDeniedException) {
                        // empty catch block
                    }
                }
            }
            return r;
        }

        public boolean getIncludeFailedBuilds() {
            return this.includeFailedBuilds;
        }

        private AbstractProject<?, ?> getProject() {
            return this.owner.getProject();
        }

        @Override
        public int getFailCount() {
            this.upToDateCheck();
            return this.failCount;
        }

        @Override
        public int getTotalCount() {
            this.upToDateCheck();
            return this.totalCount;
        }

        @Override
        public Object getResult() {
            this.upToDateCheck();
            return this;
        }

        @Override
        protected String getDescription(TestObject object) {
            throw new AssertionError();
        }

        @Override
        protected void setDescription(TestObject object, String description) {
            throw new AssertionError();
        }

        public List<AbstractTestResultAction> getIndividuals() {
            this.upToDateCheck();
            return Collections.unmodifiableList(this.individuals);
        }

        public List<AbstractProject> getDidntRun() {
            return Collections.unmodifiableList(this.didntRun);
        }

        public List<AbstractProject> getNoFingerprints() {
            return Collections.unmodifiableList(this.noFingerprints);
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="False positive. Short-circuited")
        private synchronized void upToDateCheck() {
            if (this.lastUpdated > lastChanged) {
                return;
            }
            this.lastUpdated = lastChanged + 1L;
            int failCount = 0;
            int totalCount = 0;
            ArrayList<AbstractTestResultAction> individuals = new ArrayList<AbstractTestResultAction>();
            ArrayList<AbstractProject> didntRun = new ArrayList<AbstractProject>();
            ArrayList<AbstractProject> noFingerprints = new ArrayList<AbstractProject>();
            block0: for (AbstractProject job : this.getJobs()) {
                Fingerprint.RangeSet rs = this.owner.getDownstreamRelationship(job);
                if (rs.isEmpty()) {
                    Object b = this.includeFailedBuilds ? job.getLastBuild() : job.getLastSuccessfulBuild();
                    if (b == null || b.getAction(AbstractTestResultAction.class) == null) continue;
                    if (b.getAction(Fingerprinter.FingerprintAction.class) != null) {
                        didntRun.add(job);
                        continue;
                    }
                    noFingerprints.add(job);
                    continue;
                }
                Iterator iterator = rs.listNumbersReverse().iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    AbstractBuild b = job.getBuildByNumber(n);
                    if (b == null) continue;
                    Result targetResult = this.includeFailedBuilds ? Result.FAILURE : Result.UNSTABLE;
                    if (b.isBuilding() || b.getResult() == null || b.getResult().isWorseThan(targetResult)) continue;
                    for (AbstractTestResultAction ta : b.getActions(AbstractTestResultAction.class)) {
                        failCount += ta.getFailCount();
                        totalCount += ta.getTotalCount();
                        individuals.add(ta);
                    }
                    continue block0;
                }
            }
            this.failCount = failCount;
            this.totalCount = totalCount;
            this.individuals = individuals;
            this.didntRun = didntRun;
            this.noFingerprints = noFingerprints;
        }

        public boolean getHasFingerprintAction() {
            return this.owner.getAction(Fingerprinter.FingerprintAction.class) != null;
        }

        @Override
        public String getDisplayName() {
            return Messages.AggregatedTestResultPublisher_Title();
        }

        @Override
        public String getUrlName() {
            return "aggregatedTestReport";
        }

        @Extension
        public static class RunListenerImpl
        extends RunListener<Run> {
            public void onCompleted(Run run, TaskListener listener) {
                lastChanged = System.currentTimeMillis();
            }
        }
    }
}

